/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mobile.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BundleDetails implements SdkPojo, Serializable, ToCopyableBuilder<BundleDetails.Builder, BundleDetails> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BundleDetails::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BundleDetails::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BundleDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BundleDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BundleDetails::iconUrl)).setter(setter(Builder::iconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iconUrl").build()).build();

    private static final SdkField<List<String>> AVAILABLE_PLATFORMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BundleDetails::availablePlatformsAsStrings))
            .setter(setter(Builder::availablePlatformsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availablePlatforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, TITLE_FIELD,
            VERSION_FIELD, DESCRIPTION_FIELD, ICON_URL_FIELD, AVAILABLE_PLATFORMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String title;

    private final String version;

    private final String description;

    private final String iconUrl;

    private final List<String> availablePlatforms;

    private BundleDetails(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.title = builder.title;
        this.version = builder.version;
        this.description = builder.description;
        this.iconUrl = builder.iconUrl;
        this.availablePlatforms = builder.availablePlatforms;
    }

    /**
     * Returns the value of the BundleId property for this object.
     * 
     * @return The value of the BundleId property for this object.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * Returns the value of the Title property for this object.
     * 
     * @return The value of the Title property for this object.
     */
    public String title() {
        return title;
    }

    /**
     * Returns the value of the Version property for this object.
     * 
     * @return The value of the Version property for this object.
     */
    public String version() {
        return version;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public String description() {
        return description;
    }

    /**
     * Returns the value of the IconUrl property for this object.
     * 
     * @return The value of the IconUrl property for this object.
     */
    public String iconUrl() {
        return iconUrl;
    }

    /**
     * Returns the value of the AvailablePlatforms property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailablePlatforms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AvailablePlatforms property for this object.
     */
    public List<Platform> availablePlatforms() {
        return PlatformsCopier.copyStringToEnum(availablePlatforms);
    }

    /**
     * Returns true if the AvailablePlatforms property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailablePlatforms() {
        return availablePlatforms != null && !(availablePlatforms instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AvailablePlatforms property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailablePlatforms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the AvailablePlatforms property for this object.
     */
    public List<String> availablePlatformsAsStrings() {
        return availablePlatforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(availablePlatformsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleDetails)) {
            return false;
        }
        BundleDetails other = (BundleDetails) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(title(), other.title())
                && Objects.equals(version(), other.version()) && Objects.equals(description(), other.description())
                && Objects.equals(iconUrl(), other.iconUrl())
                && Objects.equals(availablePlatformsAsStrings(), other.availablePlatformsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BundleDetails").add("BundleId", bundleId()).add("Title", title()).add("Version", version())
                .add("Description", description()).add("IconUrl", iconUrl())
                .add("AvailablePlatforms", availablePlatformsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "iconUrl":
            return Optional.ofNullable(clazz.cast(iconUrl()));
        case "availablePlatforms":
            return Optional.ofNullable(clazz.cast(availablePlatformsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BundleDetails, T> g) {
        return obj -> g.apply((BundleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BundleDetails> {
        /**
         * Sets the value of the BundleId property for this object.
         *
         * @param bundleId
         *        The new value for the BundleId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * Sets the value of the Title property for this object.
         *
         * @param title
         *        The new value for the Title property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * Sets the value of the Version property for this object.
         *
         * @param version
         *        The new value for the Version property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the IconUrl property for this object.
         *
         * @param iconUrl
         *        The new value for the IconUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconUrl(String iconUrl);

        /**
         * Sets the value of the AvailablePlatforms property for this object.
         *
         * @param availablePlatforms
         *        The new value for the AvailablePlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePlatformsWithStrings(Collection<String> availablePlatforms);

        /**
         * Sets the value of the AvailablePlatforms property for this object.
         *
         * @param availablePlatforms
         *        The new value for the AvailablePlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePlatformsWithStrings(String... availablePlatforms);

        /**
         * Sets the value of the AvailablePlatforms property for this object.
         *
         * @param availablePlatforms
         *        The new value for the AvailablePlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePlatforms(Collection<Platform> availablePlatforms);

        /**
         * Sets the value of the AvailablePlatforms property for this object.
         *
         * @param availablePlatforms
         *        The new value for the AvailablePlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePlatforms(Platform... availablePlatforms);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String title;

        private String version;

        private String description;

        private String iconUrl;

        private List<String> availablePlatforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BundleDetails model) {
            bundleId(model.bundleId);
            title(model.title);
            version(model.version);
            description(model.description);
            iconUrl(model.iconUrl);
            availablePlatformsWithStrings(model.availablePlatforms);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIconUrl() {
            return iconUrl;
        }

        @Override
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        public final Collection<String> getAvailablePlatformsAsStrings() {
            return availablePlatforms;
        }

        @Override
        public final Builder availablePlatformsWithStrings(Collection<String> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copy(availablePlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePlatformsWithStrings(String... availablePlatforms) {
            availablePlatformsWithStrings(Arrays.asList(availablePlatforms));
            return this;
        }

        @Override
        public final Builder availablePlatforms(Collection<Platform> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copyEnumToString(availablePlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePlatforms(Platform... availablePlatforms) {
            availablePlatforms(Arrays.asList(availablePlatforms));
            return this;
        }

        public final void setAvailablePlatformsWithStrings(Collection<String> availablePlatforms) {
            this.availablePlatforms = PlatformsCopier.copy(availablePlatforms);
        }

        @Override
        public BundleDetails build() {
            return new BundleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
