/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mobile.model.ProjectState;
import software.amazon.awssdk.services.mobile.model.Resource;
import software.amazon.awssdk.services.mobile.model.ResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ProjectDetails.getter(ProjectDetails::name)).setter(ProjectDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(ProjectDetails.getter(ProjectDetails::projectId)).setter(ProjectDetails.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ProjectDetails.getter(ProjectDetails::region)).setter(ProjectDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ProjectDetails.getter(ProjectDetails::stateAsString)).setter(ProjectDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(ProjectDetails.getter(ProjectDetails::createdDate)).setter(ProjectDetails.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(ProjectDetails.getter(ProjectDetails::lastUpdatedDate)).setter(ProjectDetails.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<String> CONSOLE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("consoleUrl").getter(ProjectDetails.getter(ProjectDetails::consoleUrl)).setter(ProjectDetails.setter(Builder::consoleUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleUrl").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(ProjectDetails.getter(ProjectDetails::resources)).setter(ProjectDetails.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PROJECT_ID_FIELD, REGION_FIELD, STATE_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, CONSOLE_URL_FIELD, RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String projectId;
    private final String region;
    private final String state;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final String consoleUrl;
    private final List<Resource> resources;

    private ProjectDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.region = builder.region;
        this.state = builder.state;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.consoleUrl = builder.consoleUrl;
        this.resources = builder.resources;
    }

    public final String name() {
        return this.name;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String region() {
        return this.region;
    }

    public final ProjectState state() {
        return ProjectState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final String consoleUrl() {
        return this.consoleUrl;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDetails)) {
            return false;
        }
        ProjectDetails other = (ProjectDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.consoleUrl(), other.consoleUrl()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectDetails").add("Name", (Object)this.name()).add("ProjectId", (Object)this.projectId()).add("Region", (Object)this.region()).add("State", (Object)this.stateAsString()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("ConsoleUrl", (Object)this.consoleUrl()).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "consoleUrl": {
                return Optional.ofNullable(clazz.cast(this.consoleUrl()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDetails, T> g) {
        return obj -> g.apply((ProjectDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String projectId;
        private String region;
        private String state;
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private String consoleUrl;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDetails model) {
            this.name(model.name);
            this.projectId(model.projectId);
            this.region(model.region);
            this.state(model.state);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.consoleUrl(model.consoleUrl);
            this.resources(model.resources);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ProjectState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final String getConsoleUrl() {
            return this.consoleUrl;
        }

        @Override
        public final Builder consoleUrl(String consoleUrl) {
            this.consoleUrl = consoleUrl;
            return this;
        }

        public final void setConsoleUrl(String consoleUrl) {
            this.consoleUrl = consoleUrl;
        }

        public final Collection<Resource.Builder> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources != null ? (Collection)this.resources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourcesCopier.copyFromBuilder(resources);
        }

        public ProjectDetails build() {
            return new ProjectDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDetails> {
        public Builder name(String var1);

        public Builder projectId(String var1);

        public Builder region(String var1);

        public Builder state(String var1);

        public Builder state(ProjectState var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder consoleUrl(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);
    }
}

