/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmAsyncClient;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse;
import software.amazon.awssdk.services.opsworkscm.model.ServerEvent;

public class DescribeEventsPublisher
implements SdkPublisher<DescribeEventsResponse> {
    private final OpsWorksCmAsyncClient client;
    private final DescribeEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventsPublisher(OpsWorksCmAsyncClient client, DescribeEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventsPublisher(OpsWorksCmAsyncClient client, DescribeEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServerEvent> serverEvents() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serverEvents() != null) {
                return response.serverEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEventsResponseFetcher
    implements AsyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEventsResponse> nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsPublisher.this.client.describeEvents(DescribeEventsPublisher.this.firstRequest);
            }
            return DescribeEventsPublisher.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

