/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the values required to configure logging for the pipeline. If you don't specify these values,
 * OpenSearch Ingestion will not publish logs from your application to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogPublishingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<LogPublishingOptions.Builder, LogPublishingOptions> {
    private static final SdkField<Boolean> IS_LOGGING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLoggingEnabled").getter(getter(LogPublishingOptions::isLoggingEnabled))
            .setter(setter(Builder::isLoggingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLoggingEnabled").build()).build();

    private static final SdkField<CloudWatchLogDestination> CLOUD_WATCH_LOG_DESTINATION_FIELD = SdkField
            .<CloudWatchLogDestination> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogDestination")
            .getter(getter(LogPublishingOptions::cloudWatchLogDestination)).setter(setter(Builder::cloudWatchLogDestination))
            .constructor(CloudWatchLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_LOGGING_ENABLED_FIELD,
            CLOUD_WATCH_LOG_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isLoggingEnabled;

    private final CloudWatchLogDestination cloudWatchLogDestination;

    private LogPublishingOptions(BuilderImpl builder) {
        this.isLoggingEnabled = builder.isLoggingEnabled;
        this.cloudWatchLogDestination = builder.cloudWatchLogDestination;
    }

    /**
     * <p>
     * Whether logs should be published.
     * </p>
     * 
     * @return Whether logs should be published.
     */
    public final Boolean isLoggingEnabled() {
        return isLoggingEnabled;
    }

    /**
     * <p>
     * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if
     * <code>IsLoggingEnabled</code> is set to <code>true</code>.
     * </p>
     * 
     * @return The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required
     *         if <code>IsLoggingEnabled</code> is set to <code>true</code>.
     */
    public final CloudWatchLogDestination cloudWatchLogDestination() {
        return cloudWatchLogDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isLoggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOptions)) {
            return false;
        }
        LogPublishingOptions other = (LogPublishingOptions) obj;
        return Objects.equals(isLoggingEnabled(), other.isLoggingEnabled())
                && Objects.equals(cloudWatchLogDestination(), other.cloudWatchLogDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogPublishingOptions").add("IsLoggingEnabled", isLoggingEnabled())
                .add("CloudWatchLogDestination", cloudWatchLogDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsLoggingEnabled":
            return Optional.ofNullable(clazz.cast(isLoggingEnabled()));
        case "CloudWatchLogDestination":
            return Optional.ofNullable(clazz.cast(cloudWatchLogDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPublishingOptions, T> g) {
        return obj -> g.apply((LogPublishingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogPublishingOptions> {
        /**
         * <p>
         * Whether logs should be published.
         * </p>
         * 
         * @param isLoggingEnabled
         *        Whether logs should be published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLoggingEnabled(Boolean isLoggingEnabled);

        /**
         * <p>
         * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if
         * <code>IsLoggingEnabled</code> is set to <code>true</code>.
         * </p>
         * 
         * @param cloudWatchLogDestination
         *        The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is
         *        required if <code>IsLoggingEnabled</code> is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogDestination(CloudWatchLogDestination cloudWatchLogDestination);

        /**
         * <p>
         * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if
         * <code>IsLoggingEnabled</code> is set to <code>true</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogDestination.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogDestination(CloudWatchLogDestination)}.
         * 
         * @param cloudWatchLogDestination
         *        a consumer that will call methods on {@link CloudWatchLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogDestination(CloudWatchLogDestination)
         */
        default Builder cloudWatchLogDestination(Consumer<CloudWatchLogDestination.Builder> cloudWatchLogDestination) {
            return cloudWatchLogDestination(CloudWatchLogDestination.builder().applyMutation(cloudWatchLogDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isLoggingEnabled;

        private CloudWatchLogDestination cloudWatchLogDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOptions model) {
            isLoggingEnabled(model.isLoggingEnabled);
            cloudWatchLogDestination(model.cloudWatchLogDestination);
        }

        public final Boolean getIsLoggingEnabled() {
            return isLoggingEnabled;
        }

        public final void setIsLoggingEnabled(Boolean isLoggingEnabled) {
            this.isLoggingEnabled = isLoggingEnabled;
        }

        @Override
        public final Builder isLoggingEnabled(Boolean isLoggingEnabled) {
            this.isLoggingEnabled = isLoggingEnabled;
            return this;
        }

        public final CloudWatchLogDestination.Builder getCloudWatchLogDestination() {
            return cloudWatchLogDestination != null ? cloudWatchLogDestination.toBuilder() : null;
        }

        public final void setCloudWatchLogDestination(CloudWatchLogDestination.BuilderImpl cloudWatchLogDestination) {
            this.cloudWatchLogDestination = cloudWatchLogDestination != null ? cloudWatchLogDestination.build() : null;
        }

        @Override
        public final Builder cloudWatchLogDestination(CloudWatchLogDestination cloudWatchLogDestination) {
            this.cloudWatchLogDestination = cloudWatchLogDestination;
            return this;
        }

        @Override
        public LogPublishingOptions build() {
            return new LogPublishingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
