/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSpeechSynthesisTasksResponse extends PollyResponse implements
        ToCopyableBuilder<ListSpeechSynthesisTasksResponse.Builder, ListSpeechSynthesisTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSpeechSynthesisTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SynthesisTask>> SYNTHESIS_TASKS_FIELD = SdkField
            .<List<SynthesisTask>> builder(MarshallingType.LIST)
            .getter(getter(ListSpeechSynthesisTasksResponse::synthesisTasks))
            .setter(setter(Builder::synthesisTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SynthesisTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SynthesisTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(SynthesisTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SYNTHESIS_TASKS_FIELD));

    private final String nextToken;

    private final List<SynthesisTask> synthesisTasks;

    private ListSpeechSynthesisTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.synthesisTasks = builder.synthesisTasks;
    }

    /**
     * <p>
     * An opaque pagination token returned from the previous List operation in this request. If present, this indicates
     * where to continue the listing.
     * </p>
     * 
     * @return An opaque pagination token returned from the previous List operation in this request. If present, this
     *         indicates where to continue the listing.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the SynthesisTasks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSynthesisTasks() {
        return synthesisTasks != null && !(synthesisTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of SynthesisTask objects that provides information from the specified task in the list request, including
     * output format, creation time, task status, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSynthesisTasks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of SynthesisTask objects that provides information from the specified task in the list request,
     *         including output format, creation time, task status, and so on.
     */
    public List<SynthesisTask> synthesisTasks() {
        return synthesisTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(synthesisTasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpeechSynthesisTasksResponse)) {
            return false;
        }
        ListSpeechSynthesisTasksResponse other = (ListSpeechSynthesisTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(synthesisTasks(), other.synthesisTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSpeechSynthesisTasksResponse").add("NextToken", nextToken())
                .add("SynthesisTasks", synthesisTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SynthesisTasks":
            return Optional.ofNullable(clazz.cast(synthesisTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSpeechSynthesisTasksResponse, T> g) {
        return obj -> g.apply((ListSpeechSynthesisTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSpeechSynthesisTasksResponse> {
        /**
         * <p>
         * An opaque pagination token returned from the previous List operation in this request. If present, this
         * indicates where to continue the listing.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token returned from the previous List operation in this request. If present, this
         *        indicates where to continue the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of SynthesisTask objects that provides information from the specified task in the list request,
         * including output format, creation time, task status, and so on.
         * </p>
         * 
         * @param synthesisTasks
         *        List of SynthesisTask objects that provides information from the specified task in the list request,
         *        including output format, creation time, task status, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synthesisTasks(Collection<SynthesisTask> synthesisTasks);

        /**
         * <p>
         * List of SynthesisTask objects that provides information from the specified task in the list request,
         * including output format, creation time, task status, and so on.
         * </p>
         * 
         * @param synthesisTasks
         *        List of SynthesisTask objects that provides information from the specified task in the list request,
         *        including output format, creation time, task status, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synthesisTasks(SynthesisTask... synthesisTasks);

        /**
         * <p>
         * List of SynthesisTask objects that provides information from the specified task in the list request,
         * including output format, creation time, task status, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SynthesisTask>.Builder} avoiding the need
         * to create one manually via {@link List<SynthesisTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SynthesisTask>.Builder#build()} is called immediately and
         * its result is passed to {@link #synthesisTasks(List<SynthesisTask>)}.
         * 
         * @param synthesisTasks
         *        a consumer that will call methods on {@link List<SynthesisTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #synthesisTasks(List<SynthesisTask>)
         */
        Builder synthesisTasks(Consumer<SynthesisTask.Builder>... synthesisTasks);
    }

    static final class BuilderImpl extends PollyResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SynthesisTask> synthesisTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpeechSynthesisTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            synthesisTasks(model.synthesisTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SynthesisTask.Builder> getSynthesisTasks() {
            return synthesisTasks != null ? synthesisTasks.stream().map(SynthesisTask::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder synthesisTasks(Collection<SynthesisTask> synthesisTasks) {
            this.synthesisTasks = SynthesisTasksCopier.copy(synthesisTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synthesisTasks(SynthesisTask... synthesisTasks) {
            synthesisTasks(Arrays.asList(synthesisTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synthesisTasks(Consumer<SynthesisTask.Builder>... synthesisTasks) {
            synthesisTasks(Stream.of(synthesisTasks).map(c -> SynthesisTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSynthesisTasks(Collection<SynthesisTask.BuilderImpl> synthesisTasks) {
            this.synthesisTasks = SynthesisTasksCopier.copyFromBuilder(synthesisTasks);
        }

        @Override
        public ListSpeechSynthesisTasksResponse build() {
            return new ListSpeechSynthesisTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
