/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard publish options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardPublishOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardPublishOptions.Builder, DashboardPublishOptions> {
    private static final SdkField<AdHocFilteringOption> AD_HOC_FILTERING_OPTION_FIELD = SdkField
            .<AdHocFilteringOption> builder(MarshallingType.SDK_POJO).memberName("AdHocFilteringOption")
            .getter(getter(DashboardPublishOptions::adHocFilteringOption)).setter(setter(Builder::adHocFilteringOption))
            .constructor(AdHocFilteringOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdHocFilteringOption").build())
            .build();

    private static final SdkField<ExportToCSVOption> EXPORT_TO_CSV_OPTION_FIELD = SdkField
            .<ExportToCSVOption> builder(MarshallingType.SDK_POJO).memberName("ExportToCSVOption")
            .getter(getter(DashboardPublishOptions::exportToCSVOption)).setter(setter(Builder::exportToCSVOption))
            .constructor(ExportToCSVOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCSVOption").build()).build();

    private static final SdkField<SheetControlsOption> SHEET_CONTROLS_OPTION_FIELD = SdkField
            .<SheetControlsOption> builder(MarshallingType.SDK_POJO).memberName("SheetControlsOption")
            .getter(getter(DashboardPublishOptions::sheetControlsOption)).setter(setter(Builder::sheetControlsOption))
            .constructor(SheetControlsOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlsOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_HOC_FILTERING_OPTION_FIELD,
            EXPORT_TO_CSV_OPTION_FIELD, SHEET_CONTROLS_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AdHocFilteringOption adHocFilteringOption;

    private final ExportToCSVOption exportToCSVOption;

    private final SheetControlsOption sheetControlsOption;

    private DashboardPublishOptions(BuilderImpl builder) {
        this.adHocFilteringOption = builder.adHocFilteringOption;
        this.exportToCSVOption = builder.exportToCSVOption;
        this.sheetControlsOption = builder.sheetControlsOption;
    }

    /**
     * <p>
     * Ad hoc (one-time) filtering option.
     * </p>
     * 
     * @return Ad hoc (one-time) filtering option.
     */
    public final AdHocFilteringOption adHocFilteringOption() {
        return adHocFilteringOption;
    }

    /**
     * <p>
     * Export to .csv option.
     * </p>
     * 
     * @return Export to .csv option.
     */
    public final ExportToCSVOption exportToCSVOption() {
        return exportToCSVOption;
    }

    /**
     * <p>
     * Sheet controls option.
     * </p>
     * 
     * @return Sheet controls option.
     */
    public final SheetControlsOption sheetControlsOption() {
        return sheetControlsOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adHocFilteringOption());
        hashCode = 31 * hashCode + Objects.hashCode(exportToCSVOption());
        hashCode = 31 * hashCode + Objects.hashCode(sheetControlsOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardPublishOptions)) {
            return false;
        }
        DashboardPublishOptions other = (DashboardPublishOptions) obj;
        return Objects.equals(adHocFilteringOption(), other.adHocFilteringOption())
                && Objects.equals(exportToCSVOption(), other.exportToCSVOption())
                && Objects.equals(sheetControlsOption(), other.sheetControlsOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardPublishOptions").add("AdHocFilteringOption", adHocFilteringOption())
                .add("ExportToCSVOption", exportToCSVOption()).add("SheetControlsOption", sheetControlsOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdHocFilteringOption":
            return Optional.ofNullable(clazz.cast(adHocFilteringOption()));
        case "ExportToCSVOption":
            return Optional.ofNullable(clazz.cast(exportToCSVOption()));
        case "SheetControlsOption":
            return Optional.ofNullable(clazz.cast(sheetControlsOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardPublishOptions, T> g) {
        return obj -> g.apply((DashboardPublishOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardPublishOptions> {
        /**
         * <p>
         * Ad hoc (one-time) filtering option.
         * </p>
         * 
         * @param adHocFilteringOption
         *        Ad hoc (one-time) filtering option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption);

        /**
         * <p>
         * Ad hoc (one-time) filtering option.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdHocFilteringOption.Builder} avoiding
         * the need to create one manually via {@link AdHocFilteringOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdHocFilteringOption.Builder#build()} is called immediately and
         * its result is passed to {@link #adHocFilteringOption(AdHocFilteringOption)}.
         * 
         * @param adHocFilteringOption
         *        a consumer that will call methods on {@link AdHocFilteringOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adHocFilteringOption(AdHocFilteringOption)
         */
        default Builder adHocFilteringOption(Consumer<AdHocFilteringOption.Builder> adHocFilteringOption) {
            return adHocFilteringOption(AdHocFilteringOption.builder().applyMutation(adHocFilteringOption).build());
        }

        /**
         * <p>
         * Export to .csv option.
         * </p>
         * 
         * @param exportToCSVOption
         *        Export to .csv option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToCSVOption(ExportToCSVOption exportToCSVOption);

        /**
         * <p>
         * Export to .csv option.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportToCSVOption.Builder} avoiding the
         * need to create one manually via {@link ExportToCSVOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportToCSVOption.Builder#build()} is called immediately and its
         * result is passed to {@link #exportToCSVOption(ExportToCSVOption)}.
         * 
         * @param exportToCSVOption
         *        a consumer that will call methods on {@link ExportToCSVOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportToCSVOption(ExportToCSVOption)
         */
        default Builder exportToCSVOption(Consumer<ExportToCSVOption.Builder> exportToCSVOption) {
            return exportToCSVOption(ExportToCSVOption.builder().applyMutation(exportToCSVOption).build());
        }

        /**
         * <p>
         * Sheet controls option.
         * </p>
         * 
         * @param sheetControlsOption
         *        Sheet controls option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetControlsOption(SheetControlsOption sheetControlsOption);

        /**
         * <p>
         * Sheet controls option.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlsOption.Builder} avoiding the
         * need to create one manually via {@link SheetControlsOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlsOption.Builder#build()} is called immediately and
         * its result is passed to {@link #sheetControlsOption(SheetControlsOption)}.
         * 
         * @param sheetControlsOption
         *        a consumer that will call methods on {@link SheetControlsOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetControlsOption(SheetControlsOption)
         */
        default Builder sheetControlsOption(Consumer<SheetControlsOption.Builder> sheetControlsOption) {
            return sheetControlsOption(SheetControlsOption.builder().applyMutation(sheetControlsOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AdHocFilteringOption adHocFilteringOption;

        private ExportToCSVOption exportToCSVOption;

        private SheetControlsOption sheetControlsOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardPublishOptions model) {
            adHocFilteringOption(model.adHocFilteringOption);
            exportToCSVOption(model.exportToCSVOption);
            sheetControlsOption(model.sheetControlsOption);
        }

        public final AdHocFilteringOption.Builder getAdHocFilteringOption() {
            return adHocFilteringOption != null ? adHocFilteringOption.toBuilder() : null;
        }

        public final void setAdHocFilteringOption(AdHocFilteringOption.BuilderImpl adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption != null ? adHocFilteringOption.build() : null;
        }

        @Override
        public final Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption;
            return this;
        }

        public final ExportToCSVOption.Builder getExportToCSVOption() {
            return exportToCSVOption != null ? exportToCSVOption.toBuilder() : null;
        }

        public final void setExportToCSVOption(ExportToCSVOption.BuilderImpl exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption != null ? exportToCSVOption.build() : null;
        }

        @Override
        public final Builder exportToCSVOption(ExportToCSVOption exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption;
            return this;
        }

        public final SheetControlsOption.Builder getSheetControlsOption() {
            return sheetControlsOption != null ? sheetControlsOption.toBuilder() : null;
        }

        public final void setSheetControlsOption(SheetControlsOption.BuilderImpl sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption != null ? sheetControlsOption.build() : null;
        }

        @Override
        public final Builder sheetControlsOption(SheetControlsOption sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption;
            return this;
        }

        @Override
        public DashboardPublishOptions build() {
            return new DashboardPublishOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
