/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about an audio stream. An array of <code>AudioMetadata</code> objects for the audio streams
 * found in a stored video is returned by <a>GetSegmentDetection</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioMetadata implements SdkPojo, Serializable, ToCopyableBuilder<AudioMetadata.Builder, AudioMetadata> {
    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(AudioMetadata::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(AudioMetadata::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<Long> SAMPLE_RATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SampleRate").getter(getter(AudioMetadata::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()).build();

    private static final SdkField<Long> NUMBER_OF_CHANNELS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfChannels").getter(getter(AudioMetadata::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfChannels").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD,
            DURATION_MILLIS_FIELD, SAMPLE_RATE_FIELD, NUMBER_OF_CHANNELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codec;

    private final Long durationMillis;

    private final Long sampleRate;

    private final Long numberOfChannels;

    private AudioMetadata(BuilderImpl builder) {
        this.codec = builder.codec;
        this.durationMillis = builder.durationMillis;
        this.sampleRate = builder.sampleRate;
        this.numberOfChannels = builder.numberOfChannels;
    }

    /**
     * <p>
     * The audio codec used to encode or decode the audio stream.
     * </p>
     * 
     * @return The audio codec used to encode or decode the audio stream.
     */
    public final String codec() {
        return codec;
    }

    /**
     * <p>
     * The duration of the audio stream in milliseconds.
     * </p>
     * 
     * @return The duration of the audio stream in milliseconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The sample rate for the audio stream.
     * </p>
     * 
     * @return The sample rate for the audio stream.
     */
    public final Long sampleRate() {
        return sampleRate;
    }

    /**
     * <p>
     * The number of audio channels in the segment.
     * </p>
     * 
     * @return The number of audio channels in the segment.
     */
    public final Long numberOfChannels() {
        return numberOfChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioMetadata)) {
            return false;
        }
        AudioMetadata other = (AudioMetadata) obj;
        return Objects.equals(codec(), other.codec()) && Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(sampleRate(), other.sampleRate())
                && Objects.equals(numberOfChannels(), other.numberOfChannels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioMetadata").add("Codec", codec()).add("DurationMillis", durationMillis())
                .add("SampleRate", sampleRate()).add("NumberOfChannels", numberOfChannels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioMetadata, T> g) {
        return obj -> g.apply((AudioMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioMetadata> {
        /**
         * <p>
         * The audio codec used to encode or decode the audio stream.
         * </p>
         * 
         * @param codec
         *        The audio codec used to encode or decode the audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * <p>
         * The duration of the audio stream in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the audio stream in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The sample rate for the audio stream.
         * </p>
         * 
         * @param sampleRate
         *        The sample rate for the audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Long sampleRate);

        /**
         * <p>
         * The number of audio channels in the segment.
         * </p>
         * 
         * @param numberOfChannels
         *        The number of audio channels in the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Long numberOfChannels);
    }

    static final class BuilderImpl implements Builder {
        private String codec;

        private Long durationMillis;

        private Long sampleRate;

        private Long numberOfChannels;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioMetadata model) {
            codec(model.codec);
            durationMillis(model.durationMillis);
            sampleRate(model.sampleRate);
            numberOfChannels(model.numberOfChannels);
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final Long getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Long getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Long numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Long numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        @Override
        public AudioMetadata build() {
            return new AudioMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
