/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(CreateUserRequest::collectionId)).setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(CreateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateUserRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            USER_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String collectionId;

    private final String userId;

    private final String clientRequestToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.userId = builder.userId;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The ID of an existing collection to which the new UserID needs to be created.
     * </p>
     * 
     * @return The ID of an existing collection to which the new UserID needs to be created.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * ID for the UserID to be created. This ID needs to be unique within the collection.
     * </p>
     * 
     * @return ID for the UserID to be created. This ID needs to be unique within the collection.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Idempotent token used to identify the request to <code>CreateUser</code>. If you use the same token with multiple
     * <code>CreateUser</code> requests, the same response is returned. Use ClientRequestToken to prevent the same
     * request from being processed more than once.
     * </p>
     * 
     * @return Idempotent token used to identify the request to <code>CreateUser</code>. If you use the same token with
     *         multiple <code>CreateUser</code> requests, the same response is returned. Use ClientRequestToken to
     *         prevent the same request from being processed more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("CollectionId", collectionId()).add("UserId", userId())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The ID of an existing collection to which the new UserID needs to be created.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection to which the new UserID needs to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * ID for the UserID to be created. This ID needs to be unique within the collection.
         * </p>
         * 
         * @param userId
         *        ID for the UserID to be created. This ID needs to be unique within the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Idempotent token used to identify the request to <code>CreateUser</code>. If you use the same token with
         * multiple <code>CreateUser</code> requests, the same response is returned. Use ClientRequestToken to prevent
         * the same request from being processed more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token used to identify the request to <code>CreateUser</code>. If you use the same token
         *        with multiple <code>CreateUser</code> requests, the same response is returned. Use ClientRequestToken
         *        to prevent the same request from being processed more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private String userId;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            collectionId(model.collectionId);
            userId(model.userId);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
