/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditImage> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Bytes").getter(AuditImage.getter(AuditImage::bytes)).setter(AuditImage.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()}).build();
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(AuditImage.getter(AuditImage::s3Object)).setter(AuditImage.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Object").build()}).build();
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(AuditImage.getter(AuditImage::boundingBox)).setter(AuditImage.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD, S3_OBJECT_FIELD, BOUNDING_BOX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditImage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes bytes;
    private final S3Object s3Object;
    private final BoundingBox boundingBox;

    private AuditImage(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.s3Object = builder.s3Object;
        this.boundingBox = builder.boundingBox;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditImage)) {
            return false;
        }
        AuditImage other = (AuditImage)obj;
        return Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.s3Object(), other.s3Object()) && Objects.equals(this.boundingBox(), other.boundingBox());
    }

    public final String toString() {
        return ToString.builder((String)"AuditImage").add("Bytes", (Object)(this.bytes() == null ? null : "*** Sensitive Data Redacted ***")).add("S3Object", (Object)this.s3Object()).add("BoundingBox", (Object)this.boundingBox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bytes", BYTES_FIELD);
        map.put("S3Object", S3_OBJECT_FIELD);
        map.put("BoundingBox", BOUNDING_BOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditImage, T> g) {
        return obj -> g.apply((AuditImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes bytes;
        private S3Object s3Object;
        private BoundingBox boundingBox;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditImage model) {
            this.bytes(model.bytes);
            this.s3Object(model.s3Object);
            this.boundingBox(model.boundingBox);
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public AuditImage build() {
            return new AuditImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditImage> {
        public Builder bytes(SdkBytes var1);

        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }

        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }
    }
}

