/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaAnalysisDetectModerationLabelsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaAnalysisDetectModerationLabelsConfig> {
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(MediaAnalysisDetectModerationLabelsConfig.getter(MediaAnalysisDetectModerationLabelsConfig::minConfidence)).setter(MediaAnalysisDetectModerationLabelsConfig.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final SdkField<String> PROJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectVersion").getter(MediaAnalysisDetectModerationLabelsConfig.getter(MediaAnalysisDetectModerationLabelsConfig::projectVersion)).setter(MediaAnalysisDetectModerationLabelsConfig.setter(Builder::projectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CONFIDENCE_FIELD, PROJECT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaAnalysisDetectModerationLabelsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float minConfidence;
    private final String projectVersion;

    private MediaAnalysisDetectModerationLabelsConfig(BuilderImpl builder) {
        this.minConfidence = builder.minConfidence;
        this.projectVersion = builder.projectVersion;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public final String projectVersion() {
        return this.projectVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaAnalysisDetectModerationLabelsConfig)) {
            return false;
        }
        MediaAnalysisDetectModerationLabelsConfig other = (MediaAnalysisDetectModerationLabelsConfig)obj;
        return Objects.equals(this.minConfidence(), other.minConfidence()) && Objects.equals(this.projectVersion(), other.projectVersion());
    }

    public final String toString() {
        return ToString.builder((String)"MediaAnalysisDetectModerationLabelsConfig").add("MinConfidence", (Object)this.minConfidence()).add("ProjectVersion", (Object)this.projectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
            case "ProjectVersion": {
                return Optional.ofNullable(clazz.cast(this.projectVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinConfidence", MIN_CONFIDENCE_FIELD);
        map.put("ProjectVersion", PROJECT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaAnalysisDetectModerationLabelsConfig, T> g) {
        return obj -> g.apply((MediaAnalysisDetectModerationLabelsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float minConfidence;
        private String projectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaAnalysisDetectModerationLabelsConfig model) {
            this.minConfidence(model.minConfidence);
            this.projectVersion(model.projectVersion);
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final String getProjectVersion() {
            return this.projectVersion;
        }

        public final void setProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
        }

        @Override
        public final Builder projectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        public MediaAnalysisDetectModerationLabelsConfig build() {
            return new MediaAnalysisDetectModerationLabelsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaAnalysisDetectModerationLabelsConfig> {
        public Builder minConfidence(Float var1);

        public Builder projectVersion(String var1);
    }
}

