/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.waiters.RekognitionAsyncWaiter;
import software.amazon.awssdk.services.rekognition.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRekognitionAsyncWaiter
implements RekognitionAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final RekognitionAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeProjectVersionsResponse> projectVersionTrainingCompletedWaiter;
    private final AsyncWaiter<DescribeProjectVersionsResponse> projectVersionRunningWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRekognitionAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RekognitionAsyncClient)RekognitionAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.projectVersionTrainingCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeProjectVersionsResponse.class).acceptors(DefaultRekognitionAsyncWaiter.projectVersionTrainingCompletedWaiterAcceptors())).overrideConfiguration(DefaultRekognitionAsyncWaiter.projectVersionTrainingCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.projectVersionRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeProjectVersionsResponse.class).acceptors(DefaultRekognitionAsyncWaiter.projectVersionRunningWaiterAcceptors())).overrideConfiguration(DefaultRekognitionAsyncWaiter.projectVersionRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        return this.projectVersionRunningWaiter.runAsync(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.projectVersionRunningWaiter.runAsync(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)), DefaultRekognitionAsyncWaiter.projectVersionRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        return this.projectVersionTrainingCompletedWaiter.runAsync(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.projectVersionTrainingCompletedWaiter.runAsync(() -> this.client.describeProjectVersions(this.applyWaitersUserAgent(describeProjectVersionsRequest)), DefaultRekognitionAsyncWaiter.projectVersionTrainingCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeProjectVersionsResponse>> projectVersionTrainingCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "TRAINING_COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "TRAINING_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ProjectVersionDescriptions[].Status=TRAINING_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeProjectVersionsResponse>> projectVersionRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeProjectVersionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ProjectVersionDescriptions").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ProjectVersionDescriptions[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration projectVersionTrainingCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration projectVersionRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RekognitionAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RekognitionRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RekognitionRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RekognitionAsyncWaiter.Builder {
        private RekognitionAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public RekognitionAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public RekognitionAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RekognitionAsyncWaiter.Builder client(RekognitionAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RekognitionAsyncWaiter build() {
            return new DefaultRekognitionAsyncWaiter(this);
        }
    }
}

