/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.ContentModerationAggregateBy;
import software.amazon.awssdk.services.rekognition.model.ContentModerationSortBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContentModerationRequestMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetContentModerationRequestMetadata> {
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(GetContentModerationRequestMetadata.getter(GetContentModerationRequestMetadata::sortByAsString)).setter(GetContentModerationRequestMetadata.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> AGGREGATE_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregateBy").getter(GetContentModerationRequestMetadata.getter(GetContentModerationRequestMetadata::aggregateByAsString)).setter(GetContentModerationRequestMetadata.setter(Builder::aggregateBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD, AGGREGATE_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContentModerationRequestMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sortBy;
    private final String aggregateBy;

    private GetContentModerationRequestMetadata(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.aggregateBy = builder.aggregateBy;
    }

    public final ContentModerationSortBy sortBy() {
        return ContentModerationSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final ContentModerationAggregateBy aggregateBy() {
        return ContentModerationAggregateBy.fromValue(this.aggregateBy);
    }

    public final String aggregateByAsString() {
        return this.aggregateBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentModerationRequestMetadata)) {
            return false;
        }
        GetContentModerationRequestMetadata other = (GetContentModerationRequestMetadata)obj;
        return Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.aggregateByAsString(), other.aggregateByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetContentModerationRequestMetadata").add("SortBy", (Object)this.sortByAsString()).add("AggregateBy", (Object)this.aggregateByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "AggregateBy": {
                return Optional.ofNullable(clazz.cast(this.aggregateByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SortBy", SORT_BY_FIELD);
        map.put("AggregateBy", AGGREGATE_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContentModerationRequestMetadata, T> g) {
        return obj -> g.apply((GetContentModerationRequestMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sortBy;
        private String aggregateBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentModerationRequestMetadata model) {
            this.sortBy(model.sortBy);
            this.aggregateBy(model.aggregateBy);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ContentModerationSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getAggregateBy() {
            return this.aggregateBy;
        }

        public final void setAggregateBy(String aggregateBy) {
            this.aggregateBy = aggregateBy;
        }

        @Override
        public final Builder aggregateBy(String aggregateBy) {
            this.aggregateBy = aggregateBy;
            return this;
        }

        @Override
        public final Builder aggregateBy(ContentModerationAggregateBy aggregateBy) {
            this.aggregateBy(aggregateBy == null ? null : aggregateBy.toString());
            return this;
        }

        public GetContentModerationRequestMetadata build() {
            return new GetContentModerationRequestMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetContentModerationRequestMetadata> {
        public Builder sortBy(String var1);

        public Builder sortBy(ContentModerationSortBy var1);

        public Builder aggregateBy(String var1);

        public Builder aggregateBy(ContentModerationAggregateBy var1);
    }
}

