/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TechnicalCueType {
    COLOR_BARS("ColorBars"),
    END_CREDITS("EndCredits"),
    BLACK_FRAMES("BlackFrames"),
    OPENING_CREDITS("OpeningCredits"),
    STUDIO_LOGO("StudioLogo"),
    SLATE("Slate"),
    CONTENT("Content"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TechnicalCueType> VALUE_MAP;
    private final String value;

    private TechnicalCueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TechnicalCueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TechnicalCueType> knownValues() {
        EnumSet<TechnicalCueType> knownValues = EnumSet.allOf(TechnicalCueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TechnicalCueType.class, TechnicalCueType::toString);
    }
}

