/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;

public class GetPersonTrackingIterable
implements SdkIterable<GetPersonTrackingResponse> {
    private final RekognitionClient client;
    private final GetPersonTrackingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPersonTrackingIterable(RekognitionClient client, GetPersonTrackingRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetPersonTrackingResponseFetcher();
    }

    public Iterator<GetPersonTrackingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetPersonTrackingResponseFetcher
    implements SyncPageFetcher<GetPersonTrackingResponse> {
        private GetPersonTrackingResponseFetcher() {
        }

        public boolean hasNextPage(GetPersonTrackingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPersonTrackingResponse nextPage(GetPersonTrackingResponse previousPage) {
            if (previousPage == null) {
                return GetPersonTrackingIterable.this.client.getPersonTracking(GetPersonTrackingIterable.this.firstRequest);
            }
            return GetPersonTrackingIterable.this.client.getPersonTracking((GetPersonTrackingRequest)((Object)GetPersonTrackingIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

