/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;

public class ListStreamProcessorsPublisher
implements SdkPublisher<ListStreamProcessorsResponse> {
    private final RekognitionAsyncClient client;
    private final ListStreamProcessorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStreamProcessorsPublisher(RekognitionAsyncClient client, ListStreamProcessorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStreamProcessorsPublisher(RekognitionAsyncClient client, ListStreamProcessorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStreamProcessorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStreamProcessorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStreamProcessorsResponseFetcher
    implements AsyncPageFetcher<ListStreamProcessorsResponse> {
        private ListStreamProcessorsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamProcessorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStreamProcessorsResponse> nextPage(ListStreamProcessorsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamProcessorsPublisher.this.client.listStreamProcessors(ListStreamProcessorsPublisher.this.firstRequest);
            }
            return ListStreamProcessorsPublisher.this.client.listStreamProcessors((ListStreamProcessorsRequest)((Object)ListStreamProcessorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

