/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateFleetRequest;
import software.amazon.awssdk.services.robomaker.model.CreateFleetResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.TagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.TagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesPublisher;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldsPublisher;

/**
 * Service client for accessing RoboMaker asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * This section provides documentation for the AWS RoboMaker API operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RoboMakerAsyncClient extends SdkClient {
    String SERVICE_NAME = "robomaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "robomaker";

    /**
     * Create a {@link RoboMakerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RoboMakerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RoboMakerAsyncClient}.
     */
    static RoboMakerAsyncClientBuilder builder() {
        return new DefaultRoboMakerAsyncClientBuilder();
    }

    /**
     * <p>
     * Deletes one or more worlds in a batch operation.
     * </p>
     *
     * @param batchDeleteWorldsRequest
     * @return A Java Future containing the result of the BatchDeleteWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDeleteWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteWorldsResponse> batchDeleteWorlds(BatchDeleteWorldsRequest batchDeleteWorldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more worlds in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteWorldsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteWorldsRequest#builder()}
     * </p>
     *
     * @param batchDeleteWorldsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteWorldsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDeleteWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDeleteWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteWorldsResponse> batchDeleteWorlds(
            Consumer<BatchDeleteWorldsRequest.Builder> batchDeleteWorldsRequest) {
        return batchDeleteWorlds(BatchDeleteWorldsRequest.builder().applyMutation(batchDeleteWorldsRequest).build());
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     * @return A Java Future containing the result of the BatchDescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeSimulationJobResponse> batchDescribeSimulationJob(
            BatchDescribeSimulationJobRequest batchDescribeSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeSimulationJobRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link BatchDescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.BatchDescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeSimulationJobResponse> batchDescribeSimulationJob(
            Consumer<BatchDescribeSimulationJobRequest.Builder> batchDescribeSimulationJobRequest) {
        return batchDescribeSimulationJob(BatchDescribeSimulationJobRequest.builder()
                .applyMutation(batchDescribeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param cancelDeploymentJobRequest
     * @return A Java Future containing the result of the CancelDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CancelDeploymentJobResponse> cancelDeploymentJob(
            CancelDeploymentJobRequest cancelDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelDeploymentJobRequest#builder()}
     * </p>
     *
     * @param cancelDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CancelDeploymentJobResponse> cancelDeploymentJob(
            Consumer<CancelDeploymentJobRequest.Builder> cancelDeploymentJobRequest) {
        return cancelDeploymentJob(CancelDeploymentJobRequest.builder().applyMutation(cancelDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     *
     * @param cancelSimulationJobRequest
     * @return A Java Future containing the result of the CancelSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobResponse> cancelSimulationJob(
            CancelSimulationJobRequest cancelSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSimulationJobRequest#builder()}
     * </p>
     *
     * @param cancelSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobResponse> cancelSimulationJob(
            Consumer<CancelSimulationJobRequest.Builder> cancelSimulationJobRequest) {
        return cancelSimulationJob(CancelSimulationJobRequest.builder().applyMutation(cancelSimulationJobRequest).build());
    }

    /**
     * <p>
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active
     * simulation jobs created as part of the batch.
     * </p>
     *
     * @param cancelSimulationJobBatchRequest
     * @return A Java Future containing the result of the CancelSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobBatchResponse> cancelSimulationJobBatch(
            CancelSimulationJobBatchRequest cancelSimulationJobBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active
     * simulation jobs created as part of the batch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param cancelSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link CancelSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelSimulationJobBatchResponse> cancelSimulationJobBatch(
            Consumer<CancelSimulationJobBatchRequest.Builder> cancelSimulationJobBatchRequest) {
        return cancelSimulationJobBatch(CancelSimulationJobBatchRequest.builder().applyMutation(cancelSimulationJobBatchRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the specified export job.
     * </p>
     *
     * @param cancelWorldExportJobRequest
     * @return A Java Future containing the result of the CancelWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelWorldExportJobResponse> cancelWorldExportJob(
            CancelWorldExportJobRequest cancelWorldExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelWorldExportJobRequest#builder()}
     * </p>
     *
     * @param cancelWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelWorldExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelWorldExportJobResponse> cancelWorldExportJob(
            Consumer<CancelWorldExportJobRequest.Builder> cancelWorldExportJobRequest) {
        return cancelWorldExportJob(CancelWorldExportJobRequest.builder().applyMutation(cancelWorldExportJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified world generator job.
     * </p>
     *
     * @param cancelWorldGenerationJobRequest
     * @return A Java Future containing the result of the CancelWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelWorldGenerationJobResponse> cancelWorldGenerationJob(
            CancelWorldGenerationJobRequest cancelWorldGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified world generator job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param cancelWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CancelWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelWorldGenerationJobResponse> cancelWorldGenerationJob(
            Consumer<CancelWorldGenerationJobRequest.Builder> cancelWorldGenerationJobRequest) {
        return cancelWorldGenerationJob(CancelWorldGenerationJobRequest.builder().applyMutation(cancelWorldGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createDeploymentJobRequest
     * @return A Java Future containing the result of the CreateDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateDeploymentJobResponse> createDeploymentJob(
            CreateDeploymentJobRequest createDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentJobRequest#builder()}
     * </p>
     *
     * @param createDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateDeploymentJobResponse> createDeploymentJob(
            Consumer<CreateDeploymentJobRequest.Builder> createDeploymentJobRequest) {
        return createDeploymentJob(CreateDeploymentJobRequest.builder().applyMutation(createDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param createRobotRequest
     * @return A Java Future containing the result of the CreateRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateRobotResponse> createRobot(CreateRobotRequest createRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRobotRequest#builder()}
     * </p>
     *
     * @param createRobotRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<CreateRobotResponse> createRobot(Consumer<CreateRobotRequest.Builder> createRobotRequest) {
        return createRobot(CreateRobotRequest.builder().applyMutation(createRobotRequest).build());
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     *
     * @param createRobotApplicationRequest
     * @return A Java Future containing the result of the CreateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationResponse> createRobotApplication(
            CreateRobotApplicationRequest createRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationResponse> createRobotApplication(
            Consumer<CreateRobotApplicationRequest.Builder> createRobotApplicationRequest) {
        return createRobotApplication(CreateRobotApplicationRequest.builder().applyMutation(createRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     * @return A Java Future containing the result of the CreateRobotApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationVersionResponse> createRobotApplicationVersion(
            CreateRobotApplicationVersionRequest createRobotApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRobotApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRobotApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateRobotApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRobotApplicationVersionResponse> createRobotApplicationVersion(
            Consumer<CreateRobotApplicationVersionRequest.Builder> createRobotApplicationVersionRequest) {
        return createRobotApplicationVersion(CreateRobotApplicationVersionRequest.builder()
                .applyMutation(createRobotApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     *
     * @param createSimulationApplicationRequest
     * @return A Java Future containing the result of the CreateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationResponse> createSimulationApplication(
            CreateSimulationApplicationRequest createSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationResponse> createSimulationApplication(
            Consumer<CreateSimulationApplicationRequest.Builder> createSimulationApplicationRequest) {
        return createSimulationApplication(CreateSimulationApplicationRequest.builder()
                .applyMutation(createSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     * @return A Java Future containing the result of the CreateSimulationApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationVersionResponse> createSimulationApplicationVersion(
            CreateSimulationApplicationVersionRequest createSimulationApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSimulationApplicationVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSimulationApplicationVersionResponse> createSimulationApplicationVersion(
            Consumer<CreateSimulationApplicationVersionRequest.Builder> createSimulationApplicationVersionRequest) {
        return createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest.builder()
                .applyMutation(createSimulationApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createSimulationJobRequest
     * @return A Java Future containing the result of the CreateSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSimulationJobResponse> createSimulationJob(
            CreateSimulationJobRequest createSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSimulationJobRequest#builder()}
     * </p>
     *
     * @param createSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSimulationJobResponse> createSimulationJob(
            Consumer<CreateSimulationJobRequest.Builder> createSimulationJobRequest) {
        return createSimulationJob(CreateSimulationJobRequest.builder().applyMutation(createSimulationJobRequest).build());
    }

    /**
     * <p>
     * Creates a world export job.
     * </p>
     *
     * @param createWorldExportJobRequest
     * @return A Java Future containing the result of the CreateWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorldExportJobResponse> createWorldExportJob(
            CreateWorldExportJobRequest createWorldExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a world export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorldExportJobRequest#builder()}
     * </p>
     *
     * @param createWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorldExportJobResponse> createWorldExportJob(
            Consumer<CreateWorldExportJobRequest.Builder> createWorldExportJobRequest) {
        return createWorldExportJob(CreateWorldExportJobRequest.builder().applyMutation(createWorldExportJobRequest).build());
    }

    /**
     * <p>
     * Creates worlds using the specified template.
     * </p>
     *
     * @param createWorldGenerationJobRequest
     * @return A Java Future containing the result of the CreateWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorldGenerationJobResponse> createWorldGenerationJob(
            CreateWorldGenerationJobRequest createWorldGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates worlds using the specified template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param createWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>ServiceUnavailableException The request has failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorldGenerationJobResponse> createWorldGenerationJob(
            Consumer<CreateWorldGenerationJobRequest.Builder> createWorldGenerationJobRequest) {
        return createWorldGenerationJob(CreateWorldGenerationJobRequest.builder().applyMutation(createWorldGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a world template.
     * </p>
     *
     * @param createWorldTemplateRequest
     * @return A Java Future containing the result of the CreateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorldTemplateResponse> createWorldTemplate(
            CreateWorldTemplateRequest createWorldTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorldTemplateRequest#builder()}
     * </p>
     *
     * @param createWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.CreateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorldTemplateResponse> createWorldTemplate(
            Consumer<CreateWorldTemplateRequest.Builder> createWorldTemplateRequest) {
        return createWorldTemplate(CreateWorldTemplateRequest.builder().applyMutation(createWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deleteRobotRequest
     * @return A Java Future containing the result of the DeleteRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeleteRobotResponse> deleteRobot(DeleteRobotRequest deleteRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRobotRequest#builder()}
     * </p>
     *
     * @param deleteRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeleteRobotResponse> deleteRobot(Consumer<DeleteRobotRequest.Builder> deleteRobotRequest) {
        return deleteRobot(DeleteRobotRequest.builder().applyMutation(deleteRobotRequest).build());
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     *
     * @param deleteRobotApplicationRequest
     * @return A Java Future containing the result of the DeleteRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRobotApplicationResponse> deleteRobotApplication(
            DeleteRobotApplicationRequest deleteRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRobotApplicationRequest#builder()}
     * </p>
     *
     * @param deleteRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRobotApplicationResponse> deleteRobotApplication(
            Consumer<DeleteRobotApplicationRequest.Builder> deleteRobotApplicationRequest) {
        return deleteRobotApplication(DeleteRobotApplicationRequest.builder().applyMutation(deleteRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     * @return A Java Future containing the result of the DeleteSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationApplicationResponse> deleteSimulationApplication(
            DeleteSimulationApplicationRequest deleteSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSimulationApplicationResponse> deleteSimulationApplication(
            Consumer<DeleteSimulationApplicationRequest.Builder> deleteSimulationApplicationRequest) {
        return deleteSimulationApplication(DeleteSimulationApplicationRequest.builder()
                .applyMutation(deleteSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a world template.
     * </p>
     *
     * @param deleteWorldTemplateRequest
     * @return A Java Future containing the result of the DeleteWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorldTemplateResponse> deleteWorldTemplate(
            DeleteWorldTemplateRequest deleteWorldTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorldTemplateRequest#builder()}
     * </p>
     *
     * @param deleteWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorldTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeleteWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorldTemplateResponse> deleteWorldTemplate(
            Consumer<DeleteWorldTemplateRequest.Builder> deleteWorldTemplateRequest) {
        return deleteWorldTemplate(DeleteWorldTemplateRequest.builder().applyMutation(deleteWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param deregisterRobotRequest
     * @return A Java Future containing the result of the DeregisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeregisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeregisterRobotResponse> deregisterRobot(DeregisterRobotRequest deregisterRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterRobotRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterRobotRequest#builder()}
     * </p>
     *
     * @param deregisterRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DeregisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DeregisterRobotResponse> deregisterRobot(
            Consumer<DeregisterRobotRequest.Builder> deregisterRobotRequest) {
        return deregisterRobot(DeregisterRobotRequest.builder().applyMutation(deregisterRobotRequest).build());
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeDeploymentJobRequest
     * @return A Java Future containing the result of the DescribeDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeDeploymentJobResponse> describeDeploymentJob(
            DescribeDeploymentJobRequest describeDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeploymentJobRequest#builder()}
     * </p>
     *
     * @param describeDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeploymentJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeDeploymentJobResponse> describeDeploymentJob(
            Consumer<DescribeDeploymentJobRequest.Builder> describeDeploymentJobRequest) {
        return describeDeploymentJob(DescribeDeploymentJobRequest.builder().applyMutation(describeDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeFleetRequest
     * @return A Java Future containing the result of the DescribeFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeFleetResponse> describeFleet(DescribeFleetRequest describeFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetRequest#builder()}
     * </p>
     *
     * @param describeFleetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeFleetResponse> describeFleet(Consumer<DescribeFleetRequest.Builder> describeFleetRequest) {
        return describeFleet(DescribeFleetRequest.builder().applyMutation(describeFleetRequest).build());
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param describeRobotRequest
     * @return A Java Future containing the result of the DescribeRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeRobotResponse> describeRobot(DescribeRobotRequest describeRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRobotRequest#builder()}
     * </p>
     *
     * @param describeRobotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<DescribeRobotResponse> describeRobot(Consumer<DescribeRobotRequest.Builder> describeRobotRequest) {
        return describeRobot(DescribeRobotRequest.builder().applyMutation(describeRobotRequest).build());
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     *
     * @param describeRobotApplicationRequest
     * @return A Java Future containing the result of the DescribeRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRobotApplicationResponse> describeRobotApplication(
            DescribeRobotApplicationRequest describeRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRobotApplicationRequest#builder()}
     * </p>
     *
     * @param describeRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRobotApplicationResponse> describeRobotApplication(
            Consumer<DescribeRobotApplicationRequest.Builder> describeRobotApplicationRequest) {
        return describeRobotApplication(DescribeRobotApplicationRequest.builder().applyMutation(describeRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     *
     * @param describeSimulationApplicationRequest
     * @return A Java Future containing the result of the DescribeSimulationApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationApplicationResponse> describeSimulationApplication(
            DescribeSimulationApplicationRequest describeSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param describeSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationApplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSimulationApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationApplicationResponse> describeSimulationApplication(
            Consumer<DescribeSimulationApplicationRequest.Builder> describeSimulationApplicationRequest) {
        return describeSimulationApplication(DescribeSimulationApplicationRequest.builder()
                .applyMutation(describeSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     *
     * @param describeSimulationJobRequest
     * @return A Java Future containing the result of the DescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobResponse> describeSimulationJob(
            DescribeSimulationJobRequest describeSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param describeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobResponse> describeSimulationJob(
            Consumer<DescribeSimulationJobRequest.Builder> describeSimulationJobRequest) {
        return describeSimulationJob(DescribeSimulationJobRequest.builder().applyMutation(describeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Describes a simulation job batch.
     * </p>
     *
     * @param describeSimulationJobBatchRequest
     * @return A Java Future containing the result of the DescribeSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobBatchResponse> describeSimulationJobBatch(
            DescribeSimulationJobBatchRequest describeSimulationJobBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation job batch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param describeSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSimulationJobBatchResponse> describeSimulationJobBatch(
            Consumer<DescribeSimulationJobBatchRequest.Builder> describeSimulationJobBatchRequest) {
        return describeSimulationJobBatch(DescribeSimulationJobBatchRequest.builder()
                .applyMutation(describeSimulationJobBatchRequest).build());
    }

    /**
     * <p>
     * Describes a world.
     * </p>
     *
     * @param describeWorldRequest
     * @return A Java Future containing the result of the DescribeWorld operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorld
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorldResponse> describeWorld(DescribeWorldRequest describeWorldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeWorldRequest#builder()}
     * </p>
     *
     * @param describeWorldRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeWorld operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorld
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorldResponse> describeWorld(Consumer<DescribeWorldRequest.Builder> describeWorldRequest) {
        return describeWorld(DescribeWorldRequest.builder().applyMutation(describeWorldRequest).build());
    }

    /**
     * <p>
     * Describes a world export job.
     * </p>
     *
     * @param describeWorldExportJobRequest
     * @return A Java Future containing the result of the DescribeWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldExportJobResponse> describeWorldExportJob(
            DescribeWorldExportJobRequest describeWorldExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorldExportJobRequest#builder()}
     * </p>
     *
     * @param describeWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorldExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldExportJobResponse> describeWorldExportJob(
            Consumer<DescribeWorldExportJobRequest.Builder> describeWorldExportJobRequest) {
        return describeWorldExportJob(DescribeWorldExportJobRequest.builder().applyMutation(describeWorldExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes a world generation job.
     * </p>
     *
     * @param describeWorldGenerationJobRequest
     * @return A Java Future containing the result of the DescribeWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldGenerationJobResponse> describeWorldGenerationJob(
            DescribeWorldGenerationJobRequest describeWorldGenerationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param describeWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorldGenerationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldGenerationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldGenerationJobResponse> describeWorldGenerationJob(
            Consumer<DescribeWorldGenerationJobRequest.Builder> describeWorldGenerationJobRequest) {
        return describeWorldGenerationJob(DescribeWorldGenerationJobRequest.builder()
                .applyMutation(describeWorldGenerationJobRequest).build());
    }

    /**
     * <p>
     * Describes a world template.
     * </p>
     *
     * @param describeWorldTemplateRequest
     * @return A Java Future containing the result of the DescribeWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldTemplateResponse> describeWorldTemplate(
            DescribeWorldTemplateRequest describeWorldTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorldTemplateRequest#builder()}
     * </p>
     *
     * @param describeWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.DescribeWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeWorldTemplateResponse> describeWorldTemplate(
            Consumer<DescribeWorldTemplateRequest.Builder> describeWorldTemplateRequest) {
        return describeWorldTemplate(DescribeWorldTemplateRequest.builder().applyMutation(describeWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Gets the world template body.
     * </p>
     *
     * @param getWorldTemplateBodyRequest
     * @return A Java Future containing the result of the GetWorldTemplateBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.GetWorldTemplateBody
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorldTemplateBodyResponse> getWorldTemplateBody(
            GetWorldTemplateBodyRequest getWorldTemplateBodyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the world template body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorldTemplateBodyRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorldTemplateBodyRequest#builder()}
     * </p>
     *
     * @param getWorldTemplateBodyRequest
     *        A {@link Consumer} that will call methods on {@link GetWorldTemplateBodyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorldTemplateBody operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.GetWorldTemplateBody
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorldTemplateBodyResponse> getWorldTemplateBody(
            Consumer<GetWorldTemplateBodyRequest.Builder> getWorldTemplateBodyRequest) {
        return getWorldTemplateBody(GetWorldTemplateBodyRequest.builder().applyMutation(getWorldTemplateBodyRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listDeploymentJobsRequest
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs(ListDeploymentJobsRequest listDeploymentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs(
            Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest) {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the ListDeploymentJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListDeploymentJobsResponse> listDeploymentJobs() {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator() {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator(ListDeploymentJobsRequest listDeploymentJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsPublisher publisher = client.listDeploymentJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListDeploymentJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListDeploymentJobsPublisher listDeploymentJobsPaginator(
            Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest) {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets() {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator() {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications(
            ListRobotApplicationsRequest listRobotApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) {
        return listRobotApplications(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @return A Java Future containing the result of the ListRobotApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRobotApplicationsResponse> listRobotApplications() {
        return listRobotApplications(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator() {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator(
            ListRobotApplicationsRequest listRobotApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsPublisher publisher = client.listRobotApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobotApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsPublisher listRobotApplicationsPaginator(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param listRobotsRequest
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListRobotsResponse> listRobots(ListRobotsRequest listRobotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListRobotsResponse> listRobots(Consumer<ListRobotsRequest.Builder> listRobotsRequest) {
        return listRobots(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the ListRobots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<ListRobotsResponse> listRobots() {
        return listRobots(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListRobotsPublisher listRobotsPaginator() {
        return listRobotsPaginator(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @param listRobotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListRobotsPublisher listRobotsPaginator(ListRobotsRequest listRobotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsPublisher publisher = client.listRobotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListRobotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListRobots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default ListRobotsPublisher listRobotsPaginator(Consumer<ListRobotsRequest.Builder> listRobotsRequest) {
        return listRobotsPaginator(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest) {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @return A Java Future containing the result of the ListSimulationApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationApplicationsResponse> listSimulationApplications() {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator() {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsPublisher publisher = client.listSimulationApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsPublisher listSimulationApplicationsPaginator(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest) {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     * @return A Java Future containing the result of the ListSimulationJobBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobBatchesResponse> listSimulationJobBatches(
            ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobBatchesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationJobBatchesRequest#builder()}
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobBatchesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSimulationJobBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobBatchesResponse> listSimulationJobBatches(
            Consumer<ListSimulationJobBatchesRequest.Builder> listSimulationJobBatchesRequest) {
        return listSimulationJobBatches(ListSimulationJobBatchesRequest.builder().applyMutation(listSimulationJobBatchesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesPublisher publisher = client.listSimulationJobBatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesPublisher publisher = client.listSimulationJobBatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesPublisher listSimulationJobBatchesPaginator(
            ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesPublisher publisher = client.listSimulationJobBatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesPublisher publisher = client.listSimulationJobBatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobBatchesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationJobBatchesRequest#builder()}
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobBatchesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesPublisher listSimulationJobBatchesPaginator(
            Consumer<ListSimulationJobBatchesRequest.Builder> listSimulationJobBatchesRequest) {
        return listSimulationJobBatchesPaginator(ListSimulationJobBatchesRequest.builder()
                .applyMutation(listSimulationJobBatchesRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs(ListSimulationJobsRequest listSimulationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs(
            Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest) {
        return listSimulationJobs(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @return A Java Future containing the result of the ListSimulationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSimulationJobsResponse> listSimulationJobs() {
        return listSimulationJobs(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator() {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator(ListSimulationJobsRequest listSimulationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsPublisher publisher = client.listSimulationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListSimulationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsPublisher listSimulationJobsPaginator(
            Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest) {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     *
     * @param listWorldExportJobsRequest
     * @return A Java Future containing the result of the ListWorldExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorldExportJobsResponse> listWorldExportJobs(
            ListWorldExportJobsRequest listWorldExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldExportJobsRequest#builder()}
     * </p>
     *
     * @param listWorldExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorldExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorldExportJobsResponse> listWorldExportJobs(
            Consumer<ListWorldExportJobsRequest.Builder> listWorldExportJobsRequest) {
        return listWorldExportJobs(ListWorldExportJobsRequest.builder().applyMutation(listWorldExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsPublisher publisher = client.listWorldExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsPublisher publisher = client.listWorldExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsPublisher listWorldExportJobsPaginator(ListWorldExportJobsRequest listWorldExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsPublisher publisher = client.listWorldExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsPublisher publisher = client.listWorldExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldExportJobsRequest#builder()}
     * </p>
     *
     * @param listWorldExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsPublisher listWorldExportJobsPaginator(
            Consumer<ListWorldExportJobsRequest.Builder> listWorldExportJobsRequest) {
        return listWorldExportJobsPaginator(ListWorldExportJobsRequest.builder().applyMutation(listWorldExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     * @return A Java Future containing the result of the ListWorldGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorldGenerationJobsResponse> listWorldGenerationJobs(
            ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorldGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldGenerationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorldGenerationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorldGenerationJobsResponse> listWorldGenerationJobs(
            Consumer<ListWorldGenerationJobsRequest.Builder> listWorldGenerationJobsRequest) {
        return listWorldGenerationJobs(ListWorldGenerationJobsRequest.builder().applyMutation(listWorldGenerationJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsPublisher publisher = client.listWorldGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsPublisher publisher = client.listWorldGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsPublisher listWorldGenerationJobsPaginator(
            ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsPublisher publisher = client.listWorldGenerationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsPublisher publisher = client.listWorldGenerationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorldGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldGenerationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldGenerationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsPublisher listWorldGenerationJobsPaginator(
            Consumer<ListWorldGenerationJobsRequest.Builder> listWorldGenerationJobsRequest) {
        return listWorldGenerationJobsPaginator(ListWorldGenerationJobsRequest.builder()
                .applyMutation(listWorldGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     *
     * @param listWorldTemplatesRequest
     * @return A Java Future containing the result of the ListWorldTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorldTemplatesResponse> listWorldTemplates(ListWorldTemplatesRequest listWorldTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldTemplatesRequest#builder()}
     * </p>
     *
     * @param listWorldTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorldTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorldTemplatesResponse> listWorldTemplates(
            Consumer<ListWorldTemplatesRequest.Builder> listWorldTemplatesRequest) {
        return listWorldTemplates(ListWorldTemplatesRequest.builder().applyMutation(listWorldTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesPublisher publisher = client.listWorldTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesPublisher publisher = client.listWorldTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesPublisher listWorldTemplatesPaginator(ListWorldTemplatesRequest listWorldTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesPublisher publisher = client.listWorldTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesPublisher publisher = client.listWorldTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldTemplatesRequest#builder()}
     * </p>
     *
     * @param listWorldTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorldTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesPublisher listWorldTemplatesPaginator(
            Consumer<ListWorldTemplatesRequest.Builder> listWorldTemplatesRequest) {
        return listWorldTemplatesPaginator(ListWorldTemplatesRequest.builder().applyMutation(listWorldTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     *
     * @param listWorldsRequest
     * @return A Java Future containing the result of the ListWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorldsResponse> listWorlds(ListWorldsRequest listWorldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorldsRequest#builder()}
     * </p>
     *
     * @param listWorldsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorlds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorldsResponse> listWorlds(Consumer<ListWorldsRequest.Builder> listWorldsRequest) {
        return listWorlds(ListWorldsRequest.builder().applyMutation(listWorldsRequest).build());
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsPublisher publisher = client.listWorldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsPublisher publisher = client.listWorldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)} operation.</b>
     * </p>
     *
     * @param listWorldsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsPublisher listWorldsPaginator(ListWorldsRequest listWorldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsPublisher publisher = client.listWorldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsPublisher publisher = client.listWorldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.robomaker.model.ListWorldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.robomaker.model.ListWorldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorldsRequest#builder()}
     * </p>
     *
     * @param listWorldsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.ListWorlds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsPublisher listWorldsPaginator(Consumer<ListWorldsRequest.Builder> listWorldsRequest) {
        return listWorldsPaginator(ListWorldsRequest.builder().applyMutation(listWorldsRequest).build());
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important>
     *
     * @param registerRobotRequest
     * @return A Java Future containing the result of the RegisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RegisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<RegisterRobotResponse> registerRobot(RegisterRobotRequest registerRobotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     * <important>
     * <p>
     * This API is no longer supported and will throw an error if used.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterRobotRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterRobotRequest#builder()}
     * </p>
     *
     * @param registerRobotRequest
     *        A {@link Consumer} that will call methods on {@link RegisterRobotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterRobot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RegisterRobot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated AWS RoboMaker is unable to process this request as the support for the AWS RoboMaker application
     *             deployment feature has ended. For additional information, see
     *             https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<RegisterRobotResponse> registerRobot(Consumer<RegisterRobotRequest.Builder> registerRobotRequest) {
        return registerRobot(RegisterRobotRequest.builder().applyMutation(registerRobotRequest).build());
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     *
     * @param restartSimulationJobRequest
     * @return A Java Future containing the result of the RestartSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RestartSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartSimulationJobResponse> restartSimulationJob(
            RestartSimulationJobRequest restartSimulationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link RestartSimulationJobRequest#builder()}
     * </p>
     *
     * @param restartSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link RestartSimulationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestartSimulationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.RestartSimulationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestartSimulationJobResponse> restartSimulationJob(
            Consumer<RestartSimulationJobRequest.Builder> restartSimulationJobRequest) {
        return restartSimulationJob(RestartSimulationJobRequest.builder().applyMutation(restartSimulationJobRequest).build());
    }

    /**
     * <p>
     * Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code>
     * objects.
     * </p>
     *
     * @param startSimulationJobBatchRequest
     * @return A Java Future containing the result of the StartSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.StartSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSimulationJobBatchResponse> startSimulationJobBatch(
            StartSimulationJobBatchRequest startSimulationJobBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code>
     * objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link StartSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param startSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link StartSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSimulationJobBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.StartSimulationJobBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSimulationJobBatchResponse> startSimulationJobBatch(
            Consumer<StartSimulationJobBatchRequest.Builder> startSimulationJobBatchRequest) {
        return startSimulationJobBatch(StartSimulationJobBatchRequest.builder().applyMutation(startSimulationJobBatchRequest)
                .build());
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important>
     *
     * @param syncDeploymentJobRequest
     * @return A Java Future containing the result of the SyncDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.SyncDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<SyncDeploymentJobResponse> syncDeploymentJob(SyncDeploymentJobRequest syncDeploymentJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     * <important>
     * <p>
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for
     * Deployment Service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SyncDeploymentJobRequest.Builder} avoiding the need
     * to create one manually via {@link SyncDeploymentJobRequest#builder()}
     * </p>
     *
     * @param syncDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link SyncDeploymentJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SyncDeploymentJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ConcurrentDeploymentException The failure percentage threshold percentage was met.</li>
     *         <li>IdempotentParameterMismatchException The request uses the same client token as a previous, but
     *         non-identical request. Do not reuse a client token with different requests, unless the requests are
     *         identical.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.SyncDeploymentJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Support for the AWS RoboMaker application deployment feature has ended. For additional information,
     *             see https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html.
     */
    @Deprecated
    default CompletableFuture<SyncDeploymentJobResponse> syncDeploymentJob(
            Consumer<SyncDeploymentJobRequest.Builder> syncDeploymentJobRequest) {
        return syncDeploymentJob(SyncDeploymentJobRequest.builder().applyMutation(syncDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     *
     * @param updateRobotApplicationRequest
     * @return A Java Future containing the result of the UpdateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRobotApplicationResponse> updateRobotApplication(
            UpdateRobotApplicationRequest updateRobotApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param updateRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRobotApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateRobotApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRobotApplicationResponse> updateRobotApplication(
            Consumer<UpdateRobotApplicationRequest.Builder> updateRobotApplicationRequest) {
        return updateRobotApplication(UpdateRobotApplicationRequest.builder().applyMutation(updateRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     *
     * @param updateSimulationApplicationRequest
     * @return A Java Future containing the result of the UpdateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSimulationApplicationResponse> updateSimulationApplication(
            UpdateSimulationApplicationRequest updateSimulationApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param updateSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateSimulationApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException The requested resource exceeds the maximum number allowed, or the number of
     *         concurrent stream requests exceeds the maximum number allowed.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateSimulationApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSimulationApplicationResponse> updateSimulationApplication(
            Consumer<UpdateSimulationApplicationRequest.Builder> updateSimulationApplicationRequest) {
        return updateSimulationApplication(UpdateSimulationApplicationRequest.builder()
                .applyMutation(updateSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Updates a world template.
     * </p>
     *
     * @param updateWorldTemplateRequest
     * @return A Java Future containing the result of the UpdateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorldTemplateResponse> updateWorldTemplate(
            UpdateWorldTemplateRequest updateWorldTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorldTemplateRequest#builder()}
     * </p>
     *
     * @param updateWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorldTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorldTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A parameter specified in a request is not valid, is unsupported, or cannot
     *         be used. The returned message provides an explanation of the error value.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException AWS RoboMaker is temporarily unable to process the request. Try your call again.</li>
     *         <li>InternalServerException AWS RoboMaker experienced a service issue. Try your call again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RoboMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RoboMakerAsyncClient.UpdateWorldTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorldTemplateResponse> updateWorldTemplate(
            Consumer<UpdateWorldTemplateRequest.Builder> updateWorldTemplateRequest) {
        return updateWorldTemplate(UpdateWorldTemplateRequest.builder().applyMutation(updateWorldTemplateRequest).build());
    }
}
