/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compute information for the simulation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Compute implements SdkPojo, Serializable, ToCopyableBuilder<Compute.Builder, Compute> {
    private static final SdkField<Integer> SIMULATION_UNIT_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("simulationUnitLimit").getter(getter(Compute::simulationUnitLimit))
            .setter(setter(Builder::simulationUnitLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationUnitLimit").build())
            .build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeType").getter(getter(Compute::computeTypeAsString)).setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()).build();

    private static final SdkField<Integer> GPU_UNIT_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gpuUnitLimit").getter(getter(Compute::gpuUnitLimit)).setter(setter(Builder::gpuUnitLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpuUnitLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMULATION_UNIT_LIMIT_FIELD,
            COMPUTE_TYPE_FIELD, GPU_UNIT_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer simulationUnitLimit;

    private final String computeType;

    private final Integer gpuUnitLimit;

    private Compute(BuilderImpl builder) {
        this.simulationUnitLimit = builder.simulationUnitLimit;
        this.computeType = builder.computeType;
        this.gpuUnitLimit = builder.gpuUnitLimit;
    }

    /**
     * <p>
     * The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation
     * unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume
     * up to the maximum value provided. The default is 15.
     * </p>
     * 
     * @return The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied
     *         simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU
     *         utilization you consume up to the maximum value provided. The default is 15.
     */
    public final Integer simulationUnitLimit() {
        return simulationUnitLimit;
    }

    /**
     * <p>
     * Compute type information for the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Compute type information for the simulation job.
     * @see ComputeType
     */
    public final ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * Compute type information for the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Compute type information for the simulation job.
     * @see ComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the
     * SimulationJob.
     * </p>
     * 
     * @return Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the
     *         SimulationJob.
     */
    public final Integer gpuUnitLimit() {
        return gpuUnitLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simulationUnitLimit());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gpuUnitLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compute)) {
            return false;
        }
        Compute other = (Compute) obj;
        return Objects.equals(simulationUnitLimit(), other.simulationUnitLimit())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString())
                && Objects.equals(gpuUnitLimit(), other.gpuUnitLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Compute").add("SimulationUnitLimit", simulationUnitLimit())
                .add("ComputeType", computeTypeAsString()).add("GpuUnitLimit", gpuUnitLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simulationUnitLimit":
            return Optional.ofNullable(clazz.cast(simulationUnitLimit()));
        case "computeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "gpuUnitLimit":
            return Optional.ofNullable(clazz.cast(gpuUnitLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Compute, T> g) {
        return obj -> g.apply((Compute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Compute> {
        /**
         * <p>
         * The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied
         * simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU
         * utilization you consume up to the maximum value provided. The default is 15.
         * </p>
         * 
         * @param simulationUnitLimit
         *        The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied
         *        simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU
         *        utilization you consume up to the maximum value provided. The default is 15.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationUnitLimit(Integer simulationUnitLimit);

        /**
         * <p>
         * Compute type information for the simulation job.
         * </p>
         * 
         * @param computeType
         *        Compute type information for the simulation job.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * Compute type information for the simulation job.
         * </p>
         * 
         * @param computeType
         *        Compute type information for the simulation job.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the
         * SimulationJob.
         * </p>
         * 
         * @param gpuUnitLimit
         *        Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the
         *        SimulationJob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpuUnitLimit(Integer gpuUnitLimit);
    }

    static final class BuilderImpl implements Builder {
        private Integer simulationUnitLimit;

        private String computeType;

        private Integer gpuUnitLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Compute model) {
            simulationUnitLimit(model.simulationUnitLimit);
            computeType(model.computeType);
            gpuUnitLimit(model.gpuUnitLimit);
        }

        public final Integer getSimulationUnitLimit() {
            return simulationUnitLimit;
        }

        public final void setSimulationUnitLimit(Integer simulationUnitLimit) {
            this.simulationUnitLimit = simulationUnitLimit;
        }

        @Override
        public final Builder simulationUnitLimit(Integer simulationUnitLimit) {
            this.simulationUnitLimit = simulationUnitLimit;
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final Integer getGpuUnitLimit() {
            return gpuUnitLimit;
        }

        public final void setGpuUnitLimit(Integer gpuUnitLimit) {
            this.gpuUnitLimit = gpuUnitLimit;
        }

        @Override
        public final Builder gpuUnitLimit(Integer gpuUnitLimit) {
            this.gpuUnitLimit = gpuUnitLimit;
            return this;
        }

        @Override
        public Compute build() {
            return new Compute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
