/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycluster.model.Route53RecoveryClusterResponse;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRoutingControlStateResponse
extends Route53RecoveryClusterResponse
implements ToCopyableBuilder<Builder, GetRoutingControlStateResponse> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlArn").getter(GetRoutingControlStateResponse.getter(GetRoutingControlStateResponse::routingControlArn)).setter(GetRoutingControlStateResponse.setter(Builder::routingControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlState").getter(GetRoutingControlStateResponse.getter(GetRoutingControlStateResponse::routingControlStateAsString)).setter(GetRoutingControlStateResponse.setter(Builder::routingControlState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlName").getter(GetRoutingControlStateResponse.getter(GetRoutingControlStateResponse::routingControlName)).setter(GetRoutingControlStateResponse.setter(Builder::routingControlName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD, ROUTING_CONTROL_STATE_FIELD, ROUTING_CONTROL_NAME_FIELD));
    private final String routingControlArn;
    private final String routingControlState;
    private final String routingControlName;

    private GetRoutingControlStateResponse(BuilderImpl builder) {
        super(builder);
        this.routingControlArn = builder.routingControlArn;
        this.routingControlState = builder.routingControlState;
        this.routingControlName = builder.routingControlName;
    }

    public final String routingControlArn() {
        return this.routingControlArn;
    }

    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(this.routingControlState);
    }

    public final String routingControlStateAsString() {
        return this.routingControlState;
    }

    public final String routingControlName() {
        return this.routingControlName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoutingControlStateResponse)) {
            return false;
        }
        GetRoutingControlStateResponse other = (GetRoutingControlStateResponse)((Object)obj);
        return Objects.equals(this.routingControlArn(), other.routingControlArn()) && Objects.equals(this.routingControlStateAsString(), other.routingControlStateAsString()) && Objects.equals(this.routingControlName(), other.routingControlName());
    }

    public final String toString() {
        return ToString.builder((String)"GetRoutingControlStateResponse").add("RoutingControlArn", (Object)this.routingControlArn()).add("RoutingControlState", (Object)this.routingControlStateAsString()).add("RoutingControlName", (Object)this.routingControlName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingControlArn": {
                return Optional.ofNullable(clazz.cast(this.routingControlArn()));
            }
            case "RoutingControlState": {
                return Optional.ofNullable(clazz.cast(this.routingControlStateAsString()));
            }
            case "RoutingControlName": {
                return Optional.ofNullable(clazz.cast(this.routingControlName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRoutingControlStateResponse, T> g) {
        return obj -> g.apply((GetRoutingControlStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryClusterResponse.BuilderImpl
    implements Builder {
        private String routingControlArn;
        private String routingControlState;
        private String routingControlName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoutingControlStateResponse model) {
            super(model);
            this.routingControlArn(model.routingControlArn);
            this.routingControlState(model.routingControlState);
            this.routingControlName(model.routingControlName);
        }

        public final String getRoutingControlArn() {
            return this.routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlState() {
            return this.routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final String getRoutingControlName() {
            return this.routingControlName;
        }

        public final void setRoutingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
        }

        @Override
        public final Builder routingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
            return this;
        }

        @Override
        public GetRoutingControlStateResponse build() {
            return new GetRoutingControlStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryClusterResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRoutingControlStateResponse> {
        public Builder routingControlArn(String var1);

        public Builder routingControlState(String var1);

        public Builder routingControlState(RoutingControlState var1);

        public Builder routingControlName(String var1);
    }
}

