/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckOutput;

public class ListReadinessChecksIterable
implements SdkIterable<ListReadinessChecksResponse> {
    private final Route53RecoveryReadinessClient client;
    private final ListReadinessChecksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadinessChecksIterable(Route53RecoveryReadinessClient client, ListReadinessChecksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReadinessChecksResponseFetcher();
    }

    public Iterator<ListReadinessChecksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReadinessCheckOutput> readinessChecks() {
        Function<ListReadinessChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.readinessChecks() != null) {
                return response.readinessChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadinessChecksResponseFetcher
    implements SyncPageFetcher<ListReadinessChecksResponse> {
        private ListReadinessChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListReadinessChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadinessChecksResponse nextPage(ListReadinessChecksResponse previousPage) {
            if (previousPage == null) {
                return ListReadinessChecksIterable.this.client.listReadinessChecks(ListReadinessChecksIterable.this.firstRequest);
            }
            return ListReadinessChecksIterable.this.client.listReadinessChecks((ListReadinessChecksRequest)((Object)ListReadinessChecksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

