/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFirewallRuleGroupResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<AssociateFirewallRuleGroupResponse.Builder, AssociateFirewallRuleGroupResponse> {
    private static final SdkField<FirewallRuleGroupAssociation> FIREWALL_RULE_GROUP_ASSOCIATION_FIELD = SdkField
            .<FirewallRuleGroupAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("FirewallRuleGroupAssociation")
            .getter(getter(AssociateFirewallRuleGroupResponse::firewallRuleGroupAssociation))
            .setter(setter(Builder::firewallRuleGroupAssociation))
            .constructor(FirewallRuleGroupAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIREWALL_RULE_GROUP_ASSOCIATION_FIELD));

    private final FirewallRuleGroupAssociation firewallRuleGroupAssociation;

    private AssociateFirewallRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupAssociation = builder.firewallRuleGroupAssociation;
    }

    /**
     * <p>
     * The association that you just created. The association has an ID that you can use to identify it in other
     * requests, like update and delete.
     * </p>
     * 
     * @return The association that you just created. The association has an ID that you can use to identify it in other
     *         requests, like update and delete.
     */
    public final FirewallRuleGroupAssociation firewallRuleGroupAssociation() {
        return firewallRuleGroupAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFirewallRuleGroupResponse)) {
            return false;
        }
        AssociateFirewallRuleGroupResponse other = (AssociateFirewallRuleGroupResponse) obj;
        return Objects.equals(firewallRuleGroupAssociation(), other.firewallRuleGroupAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFirewallRuleGroupResponse")
                .add("FirewallRuleGroupAssociation", firewallRuleGroupAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupAssociation":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFirewallRuleGroupResponse, T> g) {
        return obj -> g.apply((AssociateFirewallRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateFirewallRuleGroupResponse> {
        /**
         * <p>
         * The association that you just created. The association has an ID that you can use to identify it in other
         * requests, like update and delete.
         * </p>
         * 
         * @param firewallRuleGroupAssociation
         *        The association that you just created. The association has an ID that you can use to identify it in
         *        other requests, like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupAssociation(FirewallRuleGroupAssociation firewallRuleGroupAssociation);

        /**
         * <p>
         * The association that you just created. The association has an ID that you can use to identify it in other
         * requests, like update and delete.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirewallRuleGroupAssociation.Builder}
         * avoiding the need to create one manually via {@link FirewallRuleGroupAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirewallRuleGroupAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #firewallRuleGroupAssociation(FirewallRuleGroupAssociation)}.
         * 
         * @param firewallRuleGroupAssociation
         *        a consumer that will call methods on {@link FirewallRuleGroupAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRuleGroupAssociation(FirewallRuleGroupAssociation)
         */
        default Builder firewallRuleGroupAssociation(Consumer<FirewallRuleGroupAssociation.Builder> firewallRuleGroupAssociation) {
            return firewallRuleGroupAssociation(FirewallRuleGroupAssociation.builder()
                    .applyMutation(firewallRuleGroupAssociation).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private FirewallRuleGroupAssociation firewallRuleGroupAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFirewallRuleGroupResponse model) {
            super(model);
            firewallRuleGroupAssociation(model.firewallRuleGroupAssociation);
        }

        public final FirewallRuleGroupAssociation.Builder getFirewallRuleGroupAssociation() {
            return firewallRuleGroupAssociation != null ? firewallRuleGroupAssociation.toBuilder() : null;
        }

        public final void setFirewallRuleGroupAssociation(FirewallRuleGroupAssociation.BuilderImpl firewallRuleGroupAssociation) {
            this.firewallRuleGroupAssociation = firewallRuleGroupAssociation != null ? firewallRuleGroupAssociation.build()
                    : null;
        }

        @Override
        public final Builder firewallRuleGroupAssociation(FirewallRuleGroupAssociation firewallRuleGroupAssociation) {
            this.firewallRuleGroupAssociation = firewallRuleGroupAssociation;
            return this;
        }

        @Override
        public AssociateFirewallRuleGroupResponse build() {
            return new AssociateFirewallRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
