/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallDomainListsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListFirewallDomainListsResponse.Builder, ListFirewallDomainListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallDomainListsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FirewallDomainListMetadata>> FIREWALL_DOMAIN_LISTS_FIELD = SdkField
            .<List<FirewallDomainListMetadata>> builder(MarshallingType.LIST)
            .memberName("FirewallDomainLists")
            .getter(getter(ListFirewallDomainListsResponse::firewallDomainLists))
            .setter(setter(Builder::firewallDomainLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallDomainListMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallDomainListMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_DOMAIN_LISTS_FIELD));

    private final String nextToken;

    private final List<FirewallDomainListMetadata> firewallDomainLists;

    private ListFirewallDomainListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallDomainLists = builder.firewallDomainLists;
    }

    /**
     * <p>
     * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next
     * batch of objects, provide this token in your next request.
     * </p>
     * 
     * @return If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
     *         the next batch of objects, provide this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallDomainLists property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallDomainLists() {
        return firewallDomainLists != null && !(firewallDomainLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the domain lists that you have defined.
     * </p>
     * <p>
     * This might be a partial list of the domain lists that you've defined. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallDomainLists} method.
     * </p>
     * 
     * @return A list of the domain lists that you have defined. </p>
     *         <p>
     *         This might be a partial list of the domain lists that you've defined. For information, see
     *         <code>MaxResults</code>.
     */
    public final List<FirewallDomainListMetadata> firewallDomainLists() {
        return firewallDomainLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallDomainLists() ? firewallDomainLists() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallDomainListsResponse)) {
            return false;
        }
        ListFirewallDomainListsResponse other = (ListFirewallDomainListsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFirewallDomainLists() == other.hasFirewallDomainLists()
                && Objects.equals(firewallDomainLists(), other.firewallDomainLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallDomainListsResponse").add("NextToken", nextToken())
                .add("FirewallDomainLists", hasFirewallDomainLists() ? firewallDomainLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FirewallDomainLists":
            return Optional.ofNullable(clazz.cast(firewallDomainLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallDomainListsResponse, T> g) {
        return obj -> g.apply((ListFirewallDomainListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallDomainListsResponse> {
        /**
         * <p>
         * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the
         * next batch of objects, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
         *        the next batch of objects, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of the domain lists that you have defined.
         * </p>
         * <p>
         * This might be a partial list of the domain lists that you've defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallDomainLists
         *        A list of the domain lists that you have defined. </p>
         *        <p>
         *        This might be a partial list of the domain lists that you've defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainLists(Collection<FirewallDomainListMetadata> firewallDomainLists);

        /**
         * <p>
         * A list of the domain lists that you have defined.
         * </p>
         * <p>
         * This might be a partial list of the domain lists that you've defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallDomainLists
         *        A list of the domain lists that you have defined. </p>
         *        <p>
         *        This might be a partial list of the domain lists that you've defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainLists(FirewallDomainListMetadata... firewallDomainLists);

        /**
         * <p>
         * A list of the domain lists that you have defined.
         * </p>
         * <p>
         * This might be a partial list of the domain lists that you've defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata.Builder#build()} is
         * called immediately and its result is passed to {@link #firewallDomainLists(List<FirewallDomainListMetadata>)}.
         * 
         * @param firewallDomainLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallDomainLists(java.util.Collection<FirewallDomainListMetadata>)
         */
        Builder firewallDomainLists(Consumer<FirewallDomainListMetadata.Builder>... firewallDomainLists);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallDomainListMetadata> firewallDomainLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallDomainListsResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallDomainLists(model.firewallDomainLists);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallDomainListMetadata.Builder> getFirewallDomainLists() {
            List<FirewallDomainListMetadata.Builder> result = FirewallDomainListMetadataListCopier
                    .copyToBuilder(this.firewallDomainLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallDomainLists(Collection<FirewallDomainListMetadata.BuilderImpl> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListMetadataListCopier.copyFromBuilder(firewallDomainLists);
        }

        @Override
        public final Builder firewallDomainLists(Collection<FirewallDomainListMetadata> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListMetadataListCopier.copy(firewallDomainLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(FirewallDomainListMetadata... firewallDomainLists) {
            firewallDomainLists(Arrays.asList(firewallDomainLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(Consumer<FirewallDomainListMetadata.Builder>... firewallDomainLists) {
            firewallDomainLists(Stream.of(firewallDomainLists)
                    .map(c -> FirewallDomainListMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallDomainListsResponse build() {
            return new ListFirewallDomainListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
