/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFirewallConfigRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateFirewallConfigRequest.Builder, UpdateFirewallConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateFirewallConfigRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> FIREWALL_FAIL_OPEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallFailOpen").getter(getter(UpdateFirewallConfigRequest::firewallFailOpenAsString))
            .setter(setter(Builder::firewallFailOpen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallFailOpen").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            FIREWALL_FAIL_OPEN_FIELD));

    private final String resourceId;

    private final String firewallFailOpen;

    private UpdateFirewallConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.firewallFailOpen = builder.firewallFailOpen;
    }

    /**
     * <p>
     * The ID of the VPC that the configuration is for.
     * </p>
     * 
     * @return The ID of the VPC that the configuration is for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to
     * DNS Firewall fails to receive a reply.
     * </p>
     * <ul>
     * <li>
     * <p>
     * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
     * availability. DNS Firewall blocks queries that it is unable to evaluate properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     * Firewall allows queries to proceed if it is unable to properly evaluate them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firewallFailOpen}
     * will return {@link FirewallFailOpenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #firewallFailOpenAsString}.
     * </p>
     * 
     * @return Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is
     *         sent to DNS Firewall fails to receive a reply. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         By default, fail open is disabled, which means the failure mode is closed. This approach favors security
     *         over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     *         Firewall allows queries to proceed if it is unable to properly evaluate them.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * @see FirewallFailOpenStatus
     */
    public final FirewallFailOpenStatus firewallFailOpen() {
        return FirewallFailOpenStatus.fromValue(firewallFailOpen);
    }

    /**
     * <p>
     * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to
     * DNS Firewall fails to receive a reply.
     * </p>
     * <ul>
     * <li>
     * <p>
     * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
     * availability. DNS Firewall blocks queries that it is unable to evaluate properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     * Firewall allows queries to proceed if it is unable to properly evaluate them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firewallFailOpen}
     * will return {@link FirewallFailOpenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #firewallFailOpenAsString}.
     * </p>
     * 
     * @return Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is
     *         sent to DNS Firewall fails to receive a reply. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         By default, fail open is disabled, which means the failure mode is closed. This approach favors security
     *         over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     *         Firewall allows queries to proceed if it is unable to properly evaluate them.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * @see FirewallFailOpenStatus
     */
    public final String firewallFailOpenAsString() {
        return firewallFailOpen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallFailOpenAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallConfigRequest)) {
            return false;
        }
        UpdateFirewallConfigRequest other = (UpdateFirewallConfigRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(firewallFailOpenAsString(), other.firewallFailOpenAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFirewallConfigRequest").add("ResourceId", resourceId())
                .add("FirewallFailOpen", firewallFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "FirewallFailOpen":
            return Optional.ofNullable(clazz.cast(firewallFailOpenAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallConfigRequest, T> g) {
        return obj -> g.apply((UpdateFirewallConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFirewallConfigRequest> {
        /**
         * <p>
         * The ID of the VPC that the configuration is for.
         * </p>
         * 
         * @param resourceId
         *        The ID of the VPC that the configuration is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent
         * to DNS Firewall fails to receive a reply.
         * </p>
         * <ul>
         * <li>
         * <p>
         * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
         * availability. DNS Firewall blocks queries that it is unable to evaluate properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
         * Firewall allows queries to proceed if it is unable to properly evaluate them.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * </p>
         * 
         * @param firewallFailOpen
         *        Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is
         *        sent to DNS Firewall fails to receive a reply. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        By default, fail open is disabled, which means the failure mode is closed. This approach favors
         *        security over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you enable this option, the failure mode is open. This approach favors availability over security.
         *        DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * @see FirewallFailOpenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallFailOpenStatus
         */
        Builder firewallFailOpen(String firewallFailOpen);

        /**
         * <p>
         * Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent
         * to DNS Firewall fails to receive a reply.
         * </p>
         * <ul>
         * <li>
         * <p>
         * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
         * availability. DNS Firewall blocks queries that it is unable to evaluate properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
         * Firewall allows queries to proceed if it is unable to properly evaluate them.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * </p>
         * 
         * @param firewallFailOpen
         *        Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is
         *        sent to DNS Firewall fails to receive a reply. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        By default, fail open is disabled, which means the failure mode is closed. This approach favors
         *        security over availability. DNS Firewall blocks queries that it is unable to evaluate properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you enable this option, the failure mode is open. This approach favors availability over security.
         *        DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * @see FirewallFailOpenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallFailOpenStatus
         */
        Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String firewallFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallConfigRequest model) {
            super(model);
            resourceId(model.resourceId);
            firewallFailOpen(model.firewallFailOpen);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getFirewallFailOpen() {
            return firewallFailOpen;
        }

        public final void setFirewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
        }

        @Override
        public final Builder firewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
            return this;
        }

        @Override
        public final Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen) {
            this.firewallFailOpen(firewallFailOpen == null ? null : firewallFailOpen.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallConfigRequest build() {
            return new UpdateFirewallConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
