/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFirewallDomainsRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateFirewallDomainsRequest.Builder, UpdateFirewallDomainsRequest> {
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallDomainListId").getter(getter(UpdateFirewallDomainsRequest::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build())
            .build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(UpdateFirewallDomainsRequest::operationAsString))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(UpdateFirewallDomainsRequest::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_DOMAIN_LIST_ID_FIELD,
            OPERATION_FIELD, DOMAINS_FIELD));

    private final String firewallDomainListId;

    private final String operation;

    private final List<String> domains;

    private UpdateFirewallDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallDomainListId = builder.firewallDomainListId;
        this.operation = builder.operation;
        this.domains = builder.domains;
    }

    /**
     * <p>
     * The ID of the domain list whose domains you want to update.
     * </p>
     * 
     * @return The ID of the domain list whose domains you want to update.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * What you want DNS Firewall to do with the domains that you are providing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code> - Add the domains to the ones that are already in the domain list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FirewallDomainUpdateOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return What you want DNS Firewall to do with the domains that you are providing: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code> - Add the domains to the ones that are already in the domain list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
     *         </p>
     *         </li>
     * @see FirewallDomainUpdateOperation
     */
    public final FirewallDomainUpdateOperation operation() {
        return FirewallDomainUpdateOperation.fromValue(operation);
    }

    /**
     * <p>
     * What you want DNS Firewall to do with the domains that you are providing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code> - Add the domains to the ones that are already in the domain list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link FirewallDomainUpdateOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return What you want DNS Firewall to do with the domains that you are providing: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code> - Add the domains to the ones that are already in the domain list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
     *         </p>
     *         </li>
     * @see FirewallDomainUpdateOperation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of domains to use in the update operation.
     * </p>
     * <p>
     * Each domain specification in your domain list must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can optionally start with <code>*</code> (asterisk).
     * </p>
     * </li>
     * <li>
     * <p>
     * With the exception of the optional starting asterisk, it must only contain the following characters:
     * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
     * </p>
     * </li>
     * <li>
     * <p>
     * It must be from 1-255 characters in length.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return A list of domains to use in the update operation.</p>
     *         <p>
     *         Each domain specification in your domain list must satisfy the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It can optionally start with <code>*</code> (asterisk).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With the exception of the optional starting asterisk, it must only contain the following characters:
     *         <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It must be from 1-255 characters in length.
     *         </p>
     *         </li>
     */
    public final List<String> domains() {
        return domains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallDomainsRequest)) {
            return false;
        }
        UpdateFirewallDomainsRequest other = (UpdateFirewallDomainsRequest) obj;
        return Objects.equals(firewallDomainListId(), other.firewallDomainListId())
                && Objects.equals(operationAsString(), other.operationAsString()) && hasDomains() == other.hasDomains()
                && Objects.equals(domains(), other.domains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFirewallDomainsRequest").add("FirewallDomainListId", firewallDomainListId())
                .add("Operation", operationAsString()).add("Domains", hasDomains() ? domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallDomainsRequest, T> g) {
        return obj -> g.apply((UpdateFirewallDomainsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFirewallDomainsRequest> {
        /**
         * <p>
         * The ID of the domain list whose domains you want to update.
         * </p>
         * 
         * @param firewallDomainListId
         *        The ID of the domain list whose domains you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * What you want DNS Firewall to do with the domains that you are providing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code> - Add the domains to the ones that are already in the domain list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operation
         *        What you want DNS Firewall to do with the domains that you are providing: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code> - Add the domains to the ones that are already in the domain list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
         *        </p>
         *        </li>
         * @see FirewallDomainUpdateOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainUpdateOperation
         */
        Builder operation(String operation);

        /**
         * <p>
         * What you want DNS Firewall to do with the domains that you are providing:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code> - Add the domains to the ones that are already in the domain list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operation
         *        What you want DNS Firewall to do with the domains that you are providing: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code> - Add the domains to the ones that are already in the domain list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing.
         *        </p>
         *        </li>
         * @see FirewallDomainUpdateOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainUpdateOperation
         */
        Builder operation(FirewallDomainUpdateOperation operation);

        /**
         * <p>
         * A list of domains to use in the update operation.
         * </p>
         * <p>
         * Each domain specification in your domain list must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can optionally start with <code>*</code> (asterisk).
         * </p>
         * </li>
         * <li>
         * <p>
         * With the exception of the optional starting asterisk, it must only contain the following characters:
         * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
         * </p>
         * </li>
         * <li>
         * <p>
         * It must be from 1-255 characters in length.
         * </p>
         * </li>
         * </ul>
         * 
         * @param domains
         *        A list of domains to use in the update operation.</p>
         *        <p>
         *        Each domain specification in your domain list must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can optionally start with <code>*</code> (asterisk).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With the exception of the optional starting asterisk, it must only contain the following characters:
         *        <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It must be from 1-255 characters in length.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * A list of domains to use in the update operation.
         * </p>
         * <p>
         * Each domain specification in your domain list must satisfy the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It can optionally start with <code>*</code> (asterisk).
         * </p>
         * </li>
         * <li>
         * <p>
         * With the exception of the optional starting asterisk, it must only contain the following characters:
         * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
         * </p>
         * </li>
         * <li>
         * <p>
         * It must be from 1-255 characters in length.
         * </p>
         * </li>
         * </ul>
         * 
         * @param domains
         *        A list of domains to use in the update operation.</p>
         *        <p>
         *        Each domain specification in your domain list must satisfy the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It can optionally start with <code>*</code> (asterisk).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With the exception of the optional starting asterisk, it must only contain the following characters:
         *        <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It must be from 1-255 characters in length.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallDomainListId;

        private String operation;

        private List<String> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallDomainsRequest model) {
            super(model);
            firewallDomainListId(model.firewallDomainListId);
            operation(model.operation);
            domains(model.domains);
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FirewallDomainUpdateOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Collection<String> getDomains() {
            if (domains instanceof SdkAutoConstructList) {
                return null;
            }
            return domains;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallDomainsRequest build() {
            return new UpdateFirewallDomainsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
