/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.endpoints;

import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.ConfiguredS3SdkHttpRequest;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointUtils;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointBuilder;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3ObjectLambdaEndpointBuilder;
import software.amazon.awssdk.services.s3.internal.resource.S3ObjectLambdaResource;
import software.amazon.awssdk.services.s3.internal.resource.S3OutpostAccessPointBuilder;
import software.amazon.awssdk.services.s3.internal.resource.S3OutpostResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.resource.S3ResourceType;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class S3AccessPointEndpointResolver
implements S3EndpointResolver {
    private static final String S3_OUTPOSTS_NAME = "s3-outposts";
    private static final String S3_OBJECT_LAMBDA_NAME = "s3-object-lambda";

    private S3AccessPointEndpointResolver() {
    }

    public static S3AccessPointEndpointResolver create() {
        return new S3AccessPointEndpointResolver();
    }

    @Override
    public ConfiguredS3SdkHttpRequest applyEndpointConfiguration(S3EndpointResolverContext context) {
        S3Resource s3Resource = S3ArnConverter.create().convertArn(Arn.fromString((String)this.getBucketName(context)));
        if (S3ResourceType.fromValue(s3Resource.type()) != S3ResourceType.ACCESS_POINT) {
            throw new IllegalArgumentException("An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.");
        }
        Region region = context.region();
        PartitionMetadata clientPartitionMetadata = PartitionMetadata.of((Region)region);
        String arnRegion = this.validateConfiguration(context, s3Resource);
        S3AccessPointResource s3EndpointResource = (S3AccessPointResource)Validate.isInstanceOf(S3AccessPointResource.class, (Object)s3Resource, (String)"An ARN was passed as a bucket parameter to an S3 operation, however it does not appear to be a valid S3 access point ARN.", (Object[])new Object[0]);
        URI accessPointUri = this.getUriForAccessPointResource(context, arnRegion, clientPartitionMetadata, s3EndpointResource);
        String path = this.buildPath(accessPointUri, context);
        SdkHttpRequest httpRequest = (SdkHttpRequest)((SdkHttpRequest.Builder)context.request().toBuilder()).protocol(accessPointUri.getScheme()).host(accessPointUri.getHost()).port(Integer.valueOf(accessPointUri.getPort())).encodedPath(path).build();
        String signingServiceModification = s3EndpointResource.parentS3Resource().flatMap(S3AccessPointEndpointResolver::resolveSigningService).orElse(null);
        return ConfiguredS3SdkHttpRequest.builder().sdkHttpRequest(httpRequest).signingRegionModification(Region.of((String)arnRegion)).signingServiceModification(signingServiceModification).build();
    }

    private String buildPath(URI accessPointUri, S3EndpointResolverContext context) {
        String key = context.originalRequest().getValueForField("Key", String.class).orElse(null);
        StringBuilder pathBuilder = new StringBuilder();
        if (accessPointUri.getPath() != null) {
            pathBuilder.append(accessPointUri.getPath());
        }
        if (key != null) {
            if (pathBuilder.length() > 0) {
                pathBuilder.append('/');
            }
            pathBuilder.append(SdkHttpUtils.urlEncodeIgnoreSlashes((String)key));
        }
        return pathBuilder.length() > 0 ? pathBuilder.toString() : null;
    }

    private String validateConfiguration(S3EndpointResolverContext context, S3Resource s3Resource) {
        Region region = context.region();
        String arnRegion = s3Resource.region().orElseThrow(() -> new IllegalArgumentException("An S3 access point ARN must have a region"));
        S3Configuration serviceConfiguration = context.serviceConfiguration();
        if (S3EndpointUtils.isAccelerateEnabled(serviceConfiguration)) {
            throw new IllegalArgumentException("An access point ARN cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with accelerate mode enabled.");
        }
        if (S3EndpointUtils.isPathStyleAccessEnabled(serviceConfiguration)) {
            throw new IllegalArgumentException("An access point ARN cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with path style addressing enabled.");
        }
        if (!S3EndpointUtils.isArnRegionEnabled(serviceConfiguration) && this.clientRegionDiffersFromArnRegion(region, arnRegion)) {
            throw new IllegalArgumentException(String.format("The region field of the ARN being passed as a bucket parameter to an S3 operation does not match the region the client was configured with. To enable this behavior and prevent this exception set 'useArnRegionEnabled' to true in the configuration when building the S3 client. Provided region: '%s'; client region: '%s'.", arnRegion, region));
        }
        String clientPartition = PartitionMetadata.of((Region)region).id();
        if (this.illegalPartitionConfiguration(s3Resource, clientPartition)) {
            throw new IllegalArgumentException(String.format("The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the S3 client has been configured with. Provided partition: '%s'; client partition: '%s'.", s3Resource.partition().orElse(""), clientPartition));
        }
        return arnRegion;
    }

    private boolean clientRegionDiffersFromArnRegion(Region clientRegion, String arnRegion) {
        return !S3EndpointUtils.removeFipsIfNeeded(clientRegion.id()).equals(S3EndpointUtils.removeFipsIfNeeded(arnRegion));
    }

    private boolean illegalPartitionConfiguration(S3Resource s3Resource, String clientPartition) {
        return clientPartition == null || clientPartition.isEmpty() || !s3Resource.partition().isPresent() || !clientPartition.equals(s3Resource.partition().get());
    }

    private String getBucketName(S3EndpointResolverContext context) {
        return (String)context.originalRequest().getValueForField("Bucket", String.class).orElseThrow(() -> new IllegalArgumentException("Bucket name cannot be empty when parsing access points."));
    }

    private URI getUriForAccessPointResource(S3EndpointResolverContext context, String arnRegion, PartitionMetadata clientPartitionMetadata, S3AccessPointResource s3EndpointResource) {
        String accountId = s3EndpointResource.accountId().orElseThrow(() -> new IllegalArgumentException("An S3 access point ARN must have an account ID"));
        String accessPointName = s3EndpointResource.accessPointName();
        if (this.isOutpostAccessPoint(s3EndpointResource)) {
            return this.getOutpostAccessPointUri(context, arnRegion, clientPartitionMetadata, s3EndpointResource);
        }
        if (this.isObjectLambdaAccessPoint(s3EndpointResource)) {
            return this.getObjectLambdaAccessPointUri(context, arnRegion, clientPartitionMetadata, s3EndpointResource);
        }
        boolean dualstackEnabled = S3EndpointUtils.isDualstackEnabled(context.serviceConfiguration());
        boolean fipsRegionProvided = S3EndpointUtils.isFipsRegionProvided(context.region().toString(), arnRegion, S3EndpointUtils.isArnRegionEnabled(context.serviceConfiguration()));
        return S3AccessPointBuilder.create().endpointOverride(context.endpointOverride()).accessPointName(accessPointName).accountId(accountId).fipsEnabled(fipsRegionProvided).region(S3EndpointUtils.removeFipsIfNeeded(arnRegion)).protocol(context.request().protocol()).domain(clientPartitionMetadata.dnsSuffix()).dualstackEnabled(dualstackEnabled).toUri();
    }

    private boolean isOutpostAccessPoint(S3AccessPointResource s3EndpointResource) {
        return s3EndpointResource.parentS3Resource().filter(r -> r instanceof S3OutpostResource).isPresent();
    }

    private boolean isObjectLambdaAccessPoint(S3AccessPointResource s3EndpointResource) {
        return s3EndpointResource.parentS3Resource().filter(r -> r instanceof S3ObjectLambdaResource).isPresent();
    }

    private URI getOutpostAccessPointUri(S3EndpointResolverContext context, String arnRegion, PartitionMetadata clientPartitionMetadata, S3AccessPointResource s3EndpointResource) {
        if (S3EndpointUtils.isDualstackEnabled(context.serviceConfiguration())) {
            throw new IllegalArgumentException("An Outpost Access Point ARN cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with dualstack");
        }
        if (S3EndpointUtils.isFipsRegion(context.region().toString())) {
            throw new IllegalArgumentException("An access point ARN cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with a FIPS enabled region.");
        }
        S3OutpostResource parentResource = (S3OutpostResource)s3EndpointResource.parentS3Resource().get();
        return S3OutpostAccessPointBuilder.create().endpointOverride(context.endpointOverride()).accountId(s3EndpointResource.accountId().get()).outpostId(parentResource.outpostId()).region(arnRegion).accessPointName(s3EndpointResource.accessPointName()).protocol(context.request().protocol()).domain(clientPartitionMetadata.dnsSuffix()).toUri();
    }

    private URI getObjectLambdaAccessPointUri(S3EndpointResolverContext context, String arnRegion, PartitionMetadata clientPartitionMetadata, S3AccessPointResource s3EndpointResource) {
        if (S3EndpointUtils.isDualstackEnabled(context.serviceConfiguration())) {
            throw new IllegalArgumentException("An Object Lambda Access Point ARN cannot be passed as a bucket parameter to an S3 operation if the S3 client has been configured with dualstack.");
        }
        return S3ObjectLambdaEndpointBuilder.create().endpointOverride(context.endpointOverride()).accountId(s3EndpointResource.accountId().get()).region(arnRegion).accessPointName(s3EndpointResource.accessPointName()).protocol(context.request().protocol()).fipsEnabled(S3EndpointUtils.isFipsRegion(context.region().toString())).dualstackEnabled(S3EndpointUtils.isDualstackEnabled(context.serviceConfiguration())).domain(clientPartitionMetadata.dnsSuffix()).toUri();
    }

    private static Optional<String> resolveSigningService(S3Resource resource) {
        if (resource instanceof S3OutpostResource) {
            return Optional.of(S3_OUTPOSTS_NAME);
        }
        if (resource instanceof S3ObjectLambdaResource) {
            return Optional.of(S3_OBJECT_LAMBDA_NAME);
        }
        return Optional.empty();
    }
}

