/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringExecutionSummary;

public class ListMonitoringExecutionsPublisher
implements SdkPublisher<ListMonitoringExecutionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListMonitoringExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitoringExecutionsPublisher(SageMakerAsyncClient client, ListMonitoringExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitoringExecutionsPublisher(SageMakerAsyncClient client, ListMonitoringExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitoringExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitoringExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringExecutionSummary> monitoringExecutionSummaries() {
        Function<ListMonitoringExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringExecutionSummaries() != null) {
                return response.monitoringExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitoringExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitoringExecutionsResponseFetcher
    implements AsyncPageFetcher<ListMonitoringExecutionsResponse> {
        private ListMonitoringExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitoringExecutionsResponse> nextPage(ListMonitoringExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringExecutionsPublisher.this.client.listMonitoringExecutions(ListMonitoringExecutionsPublisher.this.firstRequest);
            }
            return ListMonitoringExecutionsPublisher.this.client.listMonitoringExecutions((ListMonitoringExecutionsRequest)((Object)ListMonitoringExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

