/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.VectorConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectionConfig> {
    private static final SdkField<VectorConfig> VECTOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VectorConfig").getter(CollectionConfig.getter(CollectionConfig::vectorConfig)).setter(CollectionConfig.setter(Builder::vectorConfig)).constructor(VectorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VectorConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollectionConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VectorConfig vectorConfig;
    private final Type type;

    private CollectionConfig(BuilderImpl builder) {
        this.vectorConfig = builder.vectorConfig;
        this.type = builder.type;
    }

    public final VectorConfig vectorConfig() {
        return this.vectorConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionConfig)) {
            return false;
        }
        CollectionConfig other = (CollectionConfig)obj;
        return Objects.equals(this.vectorConfig(), other.vectorConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CollectionConfig").add("VectorConfig", (Object)this.vectorConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VectorConfig": {
                return Optional.ofNullable(clazz.cast(this.vectorConfig()));
            }
        }
        return Optional.empty();
    }

    public static CollectionConfig fromVectorConfig(VectorConfig vectorConfig) {
        return (CollectionConfig)CollectionConfig.builder().vectorConfig(vectorConfig).build();
    }

    public static CollectionConfig fromVectorConfig(Consumer<VectorConfig.Builder> vectorConfig) {
        VectorConfig.Builder builder = VectorConfig.builder();
        vectorConfig.accept(builder);
        return CollectionConfig.fromVectorConfig((VectorConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<VectorConfig>> map = new HashMap<String, SdkField<VectorConfig>>();
        map.put("VectorConfig", VECTOR_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionConfig, T> g) {
        return obj -> g.apply((CollectionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        VECTOR_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private VectorConfig vectorConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionConfig model) {
            this.vectorConfig(model.vectorConfig);
        }

        public final VectorConfig.Builder getVectorConfig() {
            return this.vectorConfig != null ? this.vectorConfig.toBuilder() : null;
        }

        public final void setVectorConfig(VectorConfig.BuilderImpl vectorConfig) {
            VectorConfig oldValue = this.vectorConfig;
            this.vectorConfig = vectorConfig != null ? vectorConfig.build() : null;
            this.handleUnionValueChange(Type.VECTOR_CONFIG, oldValue, this.vectorConfig);
        }

        @Override
        public final Builder vectorConfig(VectorConfig vectorConfig) {
            VectorConfig oldValue = this.vectorConfig;
            this.vectorConfig = vectorConfig;
            this.handleUnionValueChange(Type.VECTOR_CONFIG, oldValue, this.vectorConfig);
            return this;
        }

        public CollectionConfig build() {
            return new CollectionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectionConfig> {
        public Builder vectorConfig(VectorConfig var1);

        default public Builder vectorConfig(Consumer<VectorConfig.Builder> vectorConfig) {
            return this.vectorConfig((VectorConfig)((VectorConfig.Builder)VectorConfig.builder().applyMutation(vectorConfig)).build());
        }
    }
}

