/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHubContentReferenceResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, CreateHubContentReferenceResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubArn").getter(CreateHubContentReferenceResponse.getter(CreateHubContentReferenceResponse::hubArn)).setter(CreateHubContentReferenceResponse.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentArn").getter(CreateHubContentReferenceResponse.getter(CreateHubContentReferenceResponse::hubContentArn)).setter(CreateHubContentReferenceResponse.setter(Builder::hubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD, HUB_CONTENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateHubContentReferenceResponse.memberNameToFieldInitializer();
    private final String hubArn;
    private final String hubContentArn;

    private CreateHubContentReferenceResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.hubContentArn = builder.hubContentArn;
    }

    public final String hubArn() {
        return this.hubArn;
    }

    public final String hubContentArn() {
        return this.hubContentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentReferenceResponse)) {
            return false;
        }
        CreateHubContentReferenceResponse other = (CreateHubContentReferenceResponse)((Object)obj);
        return Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.hubContentArn(), other.hubContentArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHubContentReferenceResponse").add("HubArn", (Object)this.hubArn()).add("HubContentArn", (Object)this.hubContentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "HubContentArn": {
                return Optional.ofNullable(clazz.cast(this.hubContentArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("HubContentArn", HUB_CONTENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentReferenceResponse, T> g) {
        return obj -> g.apply((CreateHubContentReferenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String hubArn;
        private String hubContentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentReferenceResponse model) {
            super(model);
            this.hubArn(model.hubArn);
            this.hubContentArn(model.hubContentArn);
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubContentArn() {
            return this.hubContentArn;
        }

        public final void setHubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
        }

        @Override
        public final Builder hubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
            return this;
        }

        @Override
        public CreateHubContentReferenceResponse build() {
            return new CreateHubContentReferenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHubContentReferenceResponse> {
        public Builder hubArn(String var1);

        public Builder hubContentArn(String var1);
    }
}

