/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.EFSFileSystemConfig;
import software.amazon.awssdk.services.sagemaker.model.FSxLustreFileSystemConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomFileSystemConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomFileSystemConfig> {
    private static final SdkField<EFSFileSystemConfig> EFS_FILE_SYSTEM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EFSFileSystemConfig").getter(CustomFileSystemConfig.getter(CustomFileSystemConfig::efsFileSystemConfig)).setter(CustomFileSystemConfig.setter(Builder::efsFileSystemConfig)).constructor(EFSFileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystemConfig").build()}).build();
    private static final SdkField<FSxLustreFileSystemConfig> F_SX_LUSTRE_FILE_SYSTEM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FSxLustreFileSystemConfig").getter(CustomFileSystemConfig.getter(CustomFileSystemConfig::fSxLustreFileSystemConfig)).setter(CustomFileSystemConfig.setter(Builder::fSxLustreFileSystemConfig)).constructor(FSxLustreFileSystemConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FSxLustreFileSystemConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_CONFIG_FIELD, F_SX_LUSTRE_FILE_SYSTEM_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomFileSystemConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EFSFileSystemConfig efsFileSystemConfig;
    private final FSxLustreFileSystemConfig fSxLustreFileSystemConfig;
    private final Type type;

    private CustomFileSystemConfig(BuilderImpl builder) {
        this.efsFileSystemConfig = builder.efsFileSystemConfig;
        this.fSxLustreFileSystemConfig = builder.fSxLustreFileSystemConfig;
        this.type = builder.type;
    }

    public final EFSFileSystemConfig efsFileSystemConfig() {
        return this.efsFileSystemConfig;
    }

    public final FSxLustreFileSystemConfig fSxLustreFileSystemConfig() {
        return this.fSxLustreFileSystemConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFileSystemConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.fSxLustreFileSystemConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystemConfig)) {
            return false;
        }
        CustomFileSystemConfig other = (CustomFileSystemConfig)obj;
        return Objects.equals(this.efsFileSystemConfig(), other.efsFileSystemConfig()) && Objects.equals(this.fSxLustreFileSystemConfig(), other.fSxLustreFileSystemConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CustomFileSystemConfig").add("EFSFileSystemConfig", (Object)this.efsFileSystemConfig()).add("FSxLustreFileSystemConfig", (Object)this.fSxLustreFileSystemConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EFSFileSystemConfig": {
                return Optional.ofNullable(clazz.cast(this.efsFileSystemConfig()));
            }
            case "FSxLustreFileSystemConfig": {
                return Optional.ofNullable(clazz.cast(this.fSxLustreFileSystemConfig()));
            }
        }
        return Optional.empty();
    }

    public static CustomFileSystemConfig fromEfsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
        return (CustomFileSystemConfig)CustomFileSystemConfig.builder().efsFileSystemConfig(efsFileSystemConfig).build();
    }

    public static CustomFileSystemConfig fromEfsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
        EFSFileSystemConfig.Builder builder = EFSFileSystemConfig.builder();
        efsFileSystemConfig.accept(builder);
        return CustomFileSystemConfig.fromEfsFileSystemConfig((EFSFileSystemConfig)builder.build());
    }

    public static CustomFileSystemConfig fromFSxLustreFileSystemConfig(FSxLustreFileSystemConfig fSxLustreFileSystemConfig) {
        return (CustomFileSystemConfig)CustomFileSystemConfig.builder().fSxLustreFileSystemConfig(fSxLustreFileSystemConfig).build();
    }

    public static CustomFileSystemConfig fromFSxLustreFileSystemConfig(Consumer<FSxLustreFileSystemConfig.Builder> fSxLustreFileSystemConfig) {
        FSxLustreFileSystemConfig.Builder builder = FSxLustreFileSystemConfig.builder();
        fSxLustreFileSystemConfig.accept(builder);
        return CustomFileSystemConfig.fromFSxLustreFileSystemConfig((FSxLustreFileSystemConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EFSFileSystemConfig", EFS_FILE_SYSTEM_CONFIG_FIELD);
        map.put("FSxLustreFileSystemConfig", F_SX_LUSTRE_FILE_SYSTEM_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystemConfig, T> g) {
        return obj -> g.apply((CustomFileSystemConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EFS_FILE_SYSTEM_CONFIG,
        F_SX_LUSTRE_FILE_SYSTEM_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EFSFileSystemConfig efsFileSystemConfig;
        private FSxLustreFileSystemConfig fSxLustreFileSystemConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystemConfig model) {
            this.efsFileSystemConfig(model.efsFileSystemConfig);
            this.fSxLustreFileSystemConfig(model.fSxLustreFileSystemConfig);
        }

        public final EFSFileSystemConfig.Builder getEfsFileSystemConfig() {
            return this.efsFileSystemConfig != null ? this.efsFileSystemConfig.toBuilder() : null;
        }

        public final void setEfsFileSystemConfig(EFSFileSystemConfig.BuilderImpl efsFileSystemConfig) {
            EFSFileSystemConfig oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig != null ? efsFileSystemConfig.build() : null;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
        }

        @Override
        public final Builder efsFileSystemConfig(EFSFileSystemConfig efsFileSystemConfig) {
            EFSFileSystemConfig oldValue = this.efsFileSystemConfig;
            this.efsFileSystemConfig = efsFileSystemConfig;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM_CONFIG, oldValue, this.efsFileSystemConfig);
            return this;
        }

        public final FSxLustreFileSystemConfig.Builder getFSxLustreFileSystemConfig() {
            return this.fSxLustreFileSystemConfig != null ? this.fSxLustreFileSystemConfig.toBuilder() : null;
        }

        public final void setFSxLustreFileSystemConfig(FSxLustreFileSystemConfig.BuilderImpl fSxLustreFileSystemConfig) {
            FSxLustreFileSystemConfig oldValue = this.fSxLustreFileSystemConfig;
            this.fSxLustreFileSystemConfig = fSxLustreFileSystemConfig != null ? fSxLustreFileSystemConfig.build() : null;
            this.handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM_CONFIG, oldValue, this.fSxLustreFileSystemConfig);
        }

        @Override
        public final Builder fSxLustreFileSystemConfig(FSxLustreFileSystemConfig fSxLustreFileSystemConfig) {
            FSxLustreFileSystemConfig oldValue = this.fSxLustreFileSystemConfig;
            this.fSxLustreFileSystemConfig = fSxLustreFileSystemConfig;
            this.handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM_CONFIG, oldValue, this.fSxLustreFileSystemConfig);
            return this;
        }

        public CustomFileSystemConfig build() {
            return new CustomFileSystemConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomFileSystemConfig> {
        public Builder efsFileSystemConfig(EFSFileSystemConfig var1);

        default public Builder efsFileSystemConfig(Consumer<EFSFileSystemConfig.Builder> efsFileSystemConfig) {
            return this.efsFileSystemConfig((EFSFileSystemConfig)((EFSFileSystemConfig.Builder)EFSFileSystemConfig.builder().applyMutation(efsFileSystemConfig)).build());
        }

        public Builder fSxLustreFileSystemConfig(FSxLustreFileSystemConfig var1);

        default public Builder fSxLustreFileSystemConfig(Consumer<FSxLustreFileSystemConfig.Builder> fSxLustreFileSystemConfig) {
            return this.fSxLustreFileSystemConfig((FSxLustreFileSystemConfig)((FSxLustreFileSystemConfig.Builder)FSxLustreFileSystemConfig.builder().applyMutation(fSxLustreFileSystemConfig)).build());
        }
    }
}

