/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.ScalingPolicyObjective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetScalingConfigurationRecommendationRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, GetScalingConfigurationRecommendationRequest> {
    private static final SdkField<String> INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceRecommendationsJobName").getter(GetScalingConfigurationRecommendationRequest.getter(GetScalingConfigurationRecommendationRequest::inferenceRecommendationsJobName)).setter(GetScalingConfigurationRecommendationRequest.setter(Builder::inferenceRecommendationsJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceRecommendationsJobName").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(GetScalingConfigurationRecommendationRequest.getter(GetScalingConfigurationRecommendationRequest::recommendationId)).setter(GetScalingConfigurationRecommendationRequest.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(GetScalingConfigurationRecommendationRequest.getter(GetScalingConfigurationRecommendationRequest::endpointName)).setter(GetScalingConfigurationRecommendationRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<Integer> TARGET_CPU_UTILIZATION_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCpuUtilizationPerCore").getter(GetScalingConfigurationRecommendationRequest.getter(GetScalingConfigurationRecommendationRequest::targetCpuUtilizationPerCore)).setter(GetScalingConfigurationRecommendationRequest.setter(Builder::targetCpuUtilizationPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCpuUtilizationPerCore").build()}).build();
    private static final SdkField<ScalingPolicyObjective> SCALING_POLICY_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingPolicyObjective").getter(GetScalingConfigurationRecommendationRequest.getter(GetScalingConfigurationRecommendationRequest::scalingPolicyObjective)).setter(GetScalingConfigurationRecommendationRequest.setter(Builder::scalingPolicyObjective)).constructor(ScalingPolicyObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicyObjective").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD, RECOMMENDATION_ID_FIELD, ENDPOINT_NAME_FIELD, TARGET_CPU_UTILIZATION_PER_CORE_FIELD, SCALING_POLICY_OBJECTIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetScalingConfigurationRecommendationRequest.memberNameToFieldInitializer();
    private final String inferenceRecommendationsJobName;
    private final String recommendationId;
    private final String endpointName;
    private final Integer targetCpuUtilizationPerCore;
    private final ScalingPolicyObjective scalingPolicyObjective;

    private GetScalingConfigurationRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceRecommendationsJobName = builder.inferenceRecommendationsJobName;
        this.recommendationId = builder.recommendationId;
        this.endpointName = builder.endpointName;
        this.targetCpuUtilizationPerCore = builder.targetCpuUtilizationPerCore;
        this.scalingPolicyObjective = builder.scalingPolicyObjective;
    }

    public final String inferenceRecommendationsJobName() {
        return this.inferenceRecommendationsJobName;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final Integer targetCpuUtilizationPerCore() {
        return this.targetCpuUtilizationPerCore;
    }

    public final ScalingPolicyObjective scalingPolicyObjective() {
        return this.scalingPolicyObjective;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceRecommendationsJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCpuUtilizationPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicyObjective());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScalingConfigurationRecommendationRequest)) {
            return false;
        }
        GetScalingConfigurationRecommendationRequest other = (GetScalingConfigurationRecommendationRequest)((Object)obj);
        return Objects.equals(this.inferenceRecommendationsJobName(), other.inferenceRecommendationsJobName()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.targetCpuUtilizationPerCore(), other.targetCpuUtilizationPerCore()) && Objects.equals(this.scalingPolicyObjective(), other.scalingPolicyObjective());
    }

    public final String toString() {
        return ToString.builder((String)"GetScalingConfigurationRecommendationRequest").add("InferenceRecommendationsJobName", (Object)this.inferenceRecommendationsJobName()).add("RecommendationId", (Object)this.recommendationId()).add("EndpointName", (Object)this.endpointName()).add("TargetCpuUtilizationPerCore", (Object)this.targetCpuUtilizationPerCore()).add("ScalingPolicyObjective", (Object)this.scalingPolicyObjective()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceRecommendationsJobName": {
                return Optional.ofNullable(clazz.cast(this.inferenceRecommendationsJobName()));
            }
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "TargetCpuUtilizationPerCore": {
                return Optional.ofNullable(clazz.cast(this.targetCpuUtilizationPerCore()));
            }
            case "ScalingPolicyObjective": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicyObjective()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceRecommendationsJobName", INFERENCE_RECOMMENDATIONS_JOB_NAME_FIELD);
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("TargetCpuUtilizationPerCore", TARGET_CPU_UTILIZATION_PER_CORE_FIELD);
        map.put("ScalingPolicyObjective", SCALING_POLICY_OBJECTIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScalingConfigurationRecommendationRequest, T> g) {
        return obj -> g.apply((GetScalingConfigurationRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String inferenceRecommendationsJobName;
        private String recommendationId;
        private String endpointName;
        private Integer targetCpuUtilizationPerCore;
        private ScalingPolicyObjective scalingPolicyObjective;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScalingConfigurationRecommendationRequest model) {
            super(model);
            this.inferenceRecommendationsJobName(model.inferenceRecommendationsJobName);
            this.recommendationId(model.recommendationId);
            this.endpointName(model.endpointName);
            this.targetCpuUtilizationPerCore(model.targetCpuUtilizationPerCore);
            this.scalingPolicyObjective(model.scalingPolicyObjective);
        }

        public final String getInferenceRecommendationsJobName() {
            return this.inferenceRecommendationsJobName;
        }

        public final void setInferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
        }

        @Override
        public final Builder inferenceRecommendationsJobName(String inferenceRecommendationsJobName) {
            this.inferenceRecommendationsJobName = inferenceRecommendationsJobName;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final Integer getTargetCpuUtilizationPerCore() {
            return this.targetCpuUtilizationPerCore;
        }

        public final void setTargetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
        }

        @Override
        public final Builder targetCpuUtilizationPerCore(Integer targetCpuUtilizationPerCore) {
            this.targetCpuUtilizationPerCore = targetCpuUtilizationPerCore;
            return this;
        }

        public final ScalingPolicyObjective.Builder getScalingPolicyObjective() {
            return this.scalingPolicyObjective != null ? this.scalingPolicyObjective.toBuilder() : null;
        }

        public final void setScalingPolicyObjective(ScalingPolicyObjective.BuilderImpl scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective != null ? scalingPolicyObjective.build() : null;
        }

        @Override
        public final Builder scalingPolicyObjective(ScalingPolicyObjective scalingPolicyObjective) {
            this.scalingPolicyObjective = scalingPolicyObjective;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScalingConfigurationRecommendationRequest build() {
            return new GetScalingConfigurationRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetScalingConfigurationRecommendationRequest> {
        public Builder inferenceRecommendationsJobName(String var1);

        public Builder recommendationId(String var1);

        public Builder endpointName(String var1);

        public Builder targetCpuUtilizationPerCore(Integer var1);

        public Builder scalingPolicyObjective(ScalingPolicyObjective var1);

        default public Builder scalingPolicyObjective(Consumer<ScalingPolicyObjective.Builder> scalingPolicyObjective) {
            return this.scalingPolicyObjective((ScalingPolicyObjective)((ScalingPolicyObjective.Builder)ScalingPolicyObjective.builder().applyMutation(scalingPolicyObjective)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

