/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceComponentComputeResourceRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceComponentComputeResourceRequirements> {
    private static final SdkField<Float> NUMBER_OF_CPU_CORES_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("NumberOfCpuCoresRequired").getter(InferenceComponentComputeResourceRequirements.getter(InferenceComponentComputeResourceRequirements::numberOfCpuCoresRequired)).setter(InferenceComponentComputeResourceRequirements.setter(Builder::numberOfCpuCoresRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCpuCoresRequired").build()}).build();
    private static final SdkField<Float> NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("NumberOfAcceleratorDevicesRequired").getter(InferenceComponentComputeResourceRequirements.getter(InferenceComponentComputeResourceRequirements::numberOfAcceleratorDevicesRequired)).setter(InferenceComponentComputeResourceRequirements.setter(Builder::numberOfAcceleratorDevicesRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAcceleratorDevicesRequired").build()}).build();
    private static final SdkField<Integer> MIN_MEMORY_REQUIRED_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinMemoryRequiredInMb").getter(InferenceComponentComputeResourceRequirements.getter(InferenceComponentComputeResourceRequirements::minMemoryRequiredInMb)).setter(InferenceComponentComputeResourceRequirements.setter(Builder::minMemoryRequiredInMb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinMemoryRequiredInMb").build()}).build();
    private static final SdkField<Integer> MAX_MEMORY_REQUIRED_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxMemoryRequiredInMb").getter(InferenceComponentComputeResourceRequirements.getter(InferenceComponentComputeResourceRequirements::maxMemoryRequiredInMb)).setter(InferenceComponentComputeResourceRequirements.setter(Builder::maxMemoryRequiredInMb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMemoryRequiredInMb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CPU_CORES_REQUIRED_FIELD, NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD, MIN_MEMORY_REQUIRED_IN_MB_FIELD, MAX_MEMORY_REQUIRED_IN_MB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceComponentComputeResourceRequirements.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float numberOfCpuCoresRequired;
    private final Float numberOfAcceleratorDevicesRequired;
    private final Integer minMemoryRequiredInMb;
    private final Integer maxMemoryRequiredInMb;

    private InferenceComponentComputeResourceRequirements(BuilderImpl builder) {
        this.numberOfCpuCoresRequired = builder.numberOfCpuCoresRequired;
        this.numberOfAcceleratorDevicesRequired = builder.numberOfAcceleratorDevicesRequired;
        this.minMemoryRequiredInMb = builder.minMemoryRequiredInMb;
        this.maxMemoryRequiredInMb = builder.maxMemoryRequiredInMb;
    }

    public final Float numberOfCpuCoresRequired() {
        return this.numberOfCpuCoresRequired;
    }

    public final Float numberOfAcceleratorDevicesRequired() {
        return this.numberOfAcceleratorDevicesRequired;
    }

    public final Integer minMemoryRequiredInMb() {
        return this.minMemoryRequiredInMb;
    }

    public final Integer maxMemoryRequiredInMb() {
        return this.maxMemoryRequiredInMb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfCpuCoresRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAcceleratorDevicesRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.minMemoryRequiredInMb());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMemoryRequiredInMb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentComputeResourceRequirements)) {
            return false;
        }
        InferenceComponentComputeResourceRequirements other = (InferenceComponentComputeResourceRequirements)obj;
        return Objects.equals(this.numberOfCpuCoresRequired(), other.numberOfCpuCoresRequired()) && Objects.equals(this.numberOfAcceleratorDevicesRequired(), other.numberOfAcceleratorDevicesRequired()) && Objects.equals(this.minMemoryRequiredInMb(), other.minMemoryRequiredInMb()) && Objects.equals(this.maxMemoryRequiredInMb(), other.maxMemoryRequiredInMb());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceComponentComputeResourceRequirements").add("NumberOfCpuCoresRequired", (Object)this.numberOfCpuCoresRequired()).add("NumberOfAcceleratorDevicesRequired", (Object)this.numberOfAcceleratorDevicesRequired()).add("MinMemoryRequiredInMb", (Object)this.minMemoryRequiredInMb()).add("MaxMemoryRequiredInMb", (Object)this.maxMemoryRequiredInMb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfCpuCoresRequired": {
                return Optional.ofNullable(clazz.cast(this.numberOfCpuCoresRequired()));
            }
            case "NumberOfAcceleratorDevicesRequired": {
                return Optional.ofNullable(clazz.cast(this.numberOfAcceleratorDevicesRequired()));
            }
            case "MinMemoryRequiredInMb": {
                return Optional.ofNullable(clazz.cast(this.minMemoryRequiredInMb()));
            }
            case "MaxMemoryRequiredInMb": {
                return Optional.ofNullable(clazz.cast(this.maxMemoryRequiredInMb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NumberOfCpuCoresRequired", NUMBER_OF_CPU_CORES_REQUIRED_FIELD);
        map.put("NumberOfAcceleratorDevicesRequired", NUMBER_OF_ACCELERATOR_DEVICES_REQUIRED_FIELD);
        map.put("MinMemoryRequiredInMb", MIN_MEMORY_REQUIRED_IN_MB_FIELD);
        map.put("MaxMemoryRequiredInMb", MAX_MEMORY_REQUIRED_IN_MB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentComputeResourceRequirements, T> g) {
        return obj -> g.apply((InferenceComponentComputeResourceRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float numberOfCpuCoresRequired;
        private Float numberOfAcceleratorDevicesRequired;
        private Integer minMemoryRequiredInMb;
        private Integer maxMemoryRequiredInMb;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentComputeResourceRequirements model) {
            this.numberOfCpuCoresRequired(model.numberOfCpuCoresRequired);
            this.numberOfAcceleratorDevicesRequired(model.numberOfAcceleratorDevicesRequired);
            this.minMemoryRequiredInMb(model.minMemoryRequiredInMb);
            this.maxMemoryRequiredInMb(model.maxMemoryRequiredInMb);
        }

        public final Float getNumberOfCpuCoresRequired() {
            return this.numberOfCpuCoresRequired;
        }

        public final void setNumberOfCpuCoresRequired(Float numberOfCpuCoresRequired) {
            this.numberOfCpuCoresRequired = numberOfCpuCoresRequired;
        }

        @Override
        public final Builder numberOfCpuCoresRequired(Float numberOfCpuCoresRequired) {
            this.numberOfCpuCoresRequired = numberOfCpuCoresRequired;
            return this;
        }

        public final Float getNumberOfAcceleratorDevicesRequired() {
            return this.numberOfAcceleratorDevicesRequired;
        }

        public final void setNumberOfAcceleratorDevicesRequired(Float numberOfAcceleratorDevicesRequired) {
            this.numberOfAcceleratorDevicesRequired = numberOfAcceleratorDevicesRequired;
        }

        @Override
        public final Builder numberOfAcceleratorDevicesRequired(Float numberOfAcceleratorDevicesRequired) {
            this.numberOfAcceleratorDevicesRequired = numberOfAcceleratorDevicesRequired;
            return this;
        }

        public final Integer getMinMemoryRequiredInMb() {
            return this.minMemoryRequiredInMb;
        }

        public final void setMinMemoryRequiredInMb(Integer minMemoryRequiredInMb) {
            this.minMemoryRequiredInMb = minMemoryRequiredInMb;
        }

        @Override
        public final Builder minMemoryRequiredInMb(Integer minMemoryRequiredInMb) {
            this.minMemoryRequiredInMb = minMemoryRequiredInMb;
            return this;
        }

        public final Integer getMaxMemoryRequiredInMb() {
            return this.maxMemoryRequiredInMb;
        }

        public final void setMaxMemoryRequiredInMb(Integer maxMemoryRequiredInMb) {
            this.maxMemoryRequiredInMb = maxMemoryRequiredInMb;
        }

        @Override
        public final Builder maxMemoryRequiredInMb(Integer maxMemoryRequiredInMb) {
            this.maxMemoryRequiredInMb = maxMemoryRequiredInMb;
            return this;
        }

        public InferenceComponentComputeResourceRequirements build() {
            return new InferenceComponentComputeResourceRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceComponentComputeResourceRequirements> {
        public Builder numberOfCpuCoresRequired(Float var1);

        public Builder numberOfAcceleratorDevicesRequired(Float var1);

        public Builder minMemoryRequiredInMb(Integer var1);

        public Builder maxMemoryRequiredInMb(Integer var1);
    }
}

