/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobForWorkteamSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobForWorkteamSummary> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobName").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::labelingJobName)).setter(LabelingJobForWorkteamSummary.setter(Builder::labelingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()}).build();
    private static final SdkField<String> JOB_REFERENCE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobReferenceCode").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::jobReferenceCode)).setter(LabelingJobForWorkteamSummary.setter(Builder::jobReferenceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCode").build()}).build();
    private static final SdkField<String> WORK_REQUESTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkRequesterAccountId").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::workRequesterAccountId)).setter(LabelingJobForWorkteamSummary.setter(Builder::workRequesterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkRequesterAccountId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::creationTime)).setter(LabelingJobForWorkteamSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<LabelCountersForWorkteam> LABEL_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelCounters").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::labelCounters)).setter(LabelingJobForWorkteamSummary.setter(Builder::labelCounters)).constructor(LabelCountersForWorkteam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfHumanWorkersPerDataObject").getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::numberOfHumanWorkersPerDataObject)).setter(LabelingJobForWorkteamSummary.setter(Builder::numberOfHumanWorkersPerDataObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfHumanWorkersPerDataObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD, JOB_REFERENCE_CODE_FIELD, WORK_REQUESTER_ACCOUNT_ID_FIELD, CREATION_TIME_FIELD, LABEL_COUNTERS_FIELD, NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LabelingJobForWorkteamSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String labelingJobName;
    private final String jobReferenceCode;
    private final String workRequesterAccountId;
    private final Instant creationTime;
    private final LabelCountersForWorkteam labelCounters;
    private final Integer numberOfHumanWorkersPerDataObject;

    private LabelingJobForWorkteamSummary(BuilderImpl builder) {
        this.labelingJobName = builder.labelingJobName;
        this.jobReferenceCode = builder.jobReferenceCode;
        this.workRequesterAccountId = builder.workRequesterAccountId;
        this.creationTime = builder.creationTime;
        this.labelCounters = builder.labelCounters;
        this.numberOfHumanWorkersPerDataObject = builder.numberOfHumanWorkersPerDataObject;
    }

    public final String labelingJobName() {
        return this.labelingJobName;
    }

    public final String jobReferenceCode() {
        return this.jobReferenceCode;
    }

    public final String workRequesterAccountId() {
        return this.workRequesterAccountId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final LabelCountersForWorkteam labelCounters() {
        return this.labelCounters;
    }

    public final Integer numberOfHumanWorkersPerDataObject() {
        return this.numberOfHumanWorkersPerDataObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobReferenceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.workRequesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfHumanWorkersPerDataObject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobForWorkteamSummary)) {
            return false;
        }
        LabelingJobForWorkteamSummary other = (LabelingJobForWorkteamSummary)obj;
        return Objects.equals(this.labelingJobName(), other.labelingJobName()) && Objects.equals(this.jobReferenceCode(), other.jobReferenceCode()) && Objects.equals(this.workRequesterAccountId(), other.workRequesterAccountId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.labelCounters(), other.labelCounters()) && Objects.equals(this.numberOfHumanWorkersPerDataObject(), other.numberOfHumanWorkersPerDataObject());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobForWorkteamSummary").add("LabelingJobName", (Object)this.labelingJobName()).add("JobReferenceCode", (Object)this.jobReferenceCode()).add("WorkRequesterAccountId", (Object)this.workRequesterAccountId()).add("CreationTime", (Object)this.creationTime()).add("LabelCounters", (Object)this.labelCounters()).add("NumberOfHumanWorkersPerDataObject", (Object)this.numberOfHumanWorkersPerDataObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobName": {
                return Optional.ofNullable(clazz.cast(this.labelingJobName()));
            }
            case "JobReferenceCode": {
                return Optional.ofNullable(clazz.cast(this.jobReferenceCode()));
            }
            case "WorkRequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.workRequesterAccountId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LabelCounters": {
                return Optional.ofNullable(clazz.cast(this.labelCounters()));
            }
            case "NumberOfHumanWorkersPerDataObject": {
                return Optional.ofNullable(clazz.cast(this.numberOfHumanWorkersPerDataObject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LabelingJobName", LABELING_JOB_NAME_FIELD);
        map.put("JobReferenceCode", JOB_REFERENCE_CODE_FIELD);
        map.put("WorkRequesterAccountId", WORK_REQUESTER_ACCOUNT_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LabelCounters", LABEL_COUNTERS_FIELD);
        map.put("NumberOfHumanWorkersPerDataObject", NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobForWorkteamSummary, T> g) {
        return obj -> g.apply((LabelingJobForWorkteamSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelingJobName;
        private String jobReferenceCode;
        private String workRequesterAccountId;
        private Instant creationTime;
        private LabelCountersForWorkteam labelCounters;
        private Integer numberOfHumanWorkersPerDataObject;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobForWorkteamSummary model) {
            this.labelingJobName(model.labelingJobName);
            this.jobReferenceCode(model.jobReferenceCode);
            this.workRequesterAccountId(model.workRequesterAccountId);
            this.creationTime(model.creationTime);
            this.labelCounters(model.labelCounters);
            this.numberOfHumanWorkersPerDataObject(model.numberOfHumanWorkersPerDataObject);
        }

        public final String getLabelingJobName() {
            return this.labelingJobName;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final String getJobReferenceCode() {
            return this.jobReferenceCode;
        }

        public final void setJobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
        }

        @Override
        public final Builder jobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
            return this;
        }

        public final String getWorkRequesterAccountId() {
            return this.workRequesterAccountId;
        }

        public final void setWorkRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
        }

        @Override
        public final Builder workRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final LabelCountersForWorkteam.Builder getLabelCounters() {
            return this.labelCounters != null ? this.labelCounters.toBuilder() : null;
        }

        public final void setLabelCounters(LabelCountersForWorkteam.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        @Override
        public final Builder labelCounters(LabelCountersForWorkteam labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final Integer getNumberOfHumanWorkersPerDataObject() {
            return this.numberOfHumanWorkersPerDataObject;
        }

        public final void setNumberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
        }

        @Override
        public final Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
            return this;
        }

        public LabelingJobForWorkteamSummary build() {
            return new LabelingJobForWorkteamSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobForWorkteamSummary> {
        public Builder labelingJobName(String var1);

        public Builder jobReferenceCode(String var1);

        public Builder workRequesterAccountId(String var1);

        public Builder creationTime(Instant var1);

        public Builder labelCounters(LabelCountersForWorkteam var1);

        default public Builder labelCounters(Consumer<LabelCountersForWorkteam.Builder> labelCounters) {
            return this.labelCounters((LabelCountersForWorkteam)((LabelCountersForWorkteam.Builder)LabelCountersForWorkteam.builder().applyMutation(labelCounters)).build());
        }

        public Builder numberOfHumanWorkersPerDataObject(Integer var1);
    }
}

