/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentListCopier;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceExperimentsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListInferenceExperimentsResponse> {
    private static final SdkField<List<InferenceExperimentSummary>> INFERENCE_EXPERIMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceExperiments").getter(ListInferenceExperimentsResponse.getter(ListInferenceExperimentsResponse::inferenceExperiments)).setter(ListInferenceExperimentsResponse.setter(Builder::inferenceExperiments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExperiments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceExperimentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceExperimentsResponse.getter(ListInferenceExperimentsResponse::nextToken)).setter(ListInferenceExperimentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_EXPERIMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceExperimentsResponse.memberNameToFieldInitializer();
    private final List<InferenceExperimentSummary> inferenceExperiments;
    private final String nextToken;

    private ListInferenceExperimentsResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceExperiments = builder.inferenceExperiments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInferenceExperiments() {
        return this.inferenceExperiments != null && !(this.inferenceExperiments instanceof SdkAutoConstructList);
    }

    public final List<InferenceExperimentSummary> inferenceExperiments() {
        return this.inferenceExperiments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceExperiments() ? this.inferenceExperiments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExperimentsResponse)) {
            return false;
        }
        ListInferenceExperimentsResponse other = (ListInferenceExperimentsResponse)((Object)obj);
        return this.hasInferenceExperiments() == other.hasInferenceExperiments() && Objects.equals(this.inferenceExperiments(), other.inferenceExperiments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceExperimentsResponse").add("InferenceExperiments", this.hasInferenceExperiments() ? this.inferenceExperiments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceExperiments": {
                return Optional.ofNullable(clazz.cast(this.inferenceExperiments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceExperiments", INFERENCE_EXPERIMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExperimentsResponse, T> g) {
        return obj -> g.apply((ListInferenceExperimentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<InferenceExperimentSummary> inferenceExperiments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExperimentsResponse model) {
            super(model);
            this.inferenceExperiments(model.inferenceExperiments);
            this.nextToken(model.nextToken);
        }

        public final List<InferenceExperimentSummary.Builder> getInferenceExperiments() {
            List<InferenceExperimentSummary.Builder> result = InferenceExperimentListCopier.copyToBuilder(this.inferenceExperiments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceExperiments(Collection<InferenceExperimentSummary.BuilderImpl> inferenceExperiments) {
            this.inferenceExperiments = InferenceExperimentListCopier.copyFromBuilder(inferenceExperiments);
        }

        @Override
        public final Builder inferenceExperiments(Collection<InferenceExperimentSummary> inferenceExperiments) {
            this.inferenceExperiments = InferenceExperimentListCopier.copy(inferenceExperiments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExperiments(InferenceExperimentSummary ... inferenceExperiments) {
            this.inferenceExperiments(Arrays.asList(inferenceExperiments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExperiments(Consumer<InferenceExperimentSummary.Builder> ... inferenceExperiments) {
            this.inferenceExperiments(Stream.of(inferenceExperiments).map(c -> (InferenceExperimentSummary)((InferenceExperimentSummary.Builder)InferenceExperimentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceExperimentsResponse build() {
            return new ListInferenceExperimentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceExperimentsResponse> {
        public Builder inferenceExperiments(Collection<InferenceExperimentSummary> var1);

        public Builder inferenceExperiments(InferenceExperimentSummary ... var1);

        public Builder inferenceExperiments(Consumer<InferenceExperimentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

