/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SpaceDetails;
import software.amazon.awssdk.services.sagemaker.model.SpaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSpacesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListSpacesResponse> {
    private static final SdkField<List<SpaceDetails>> SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Spaces").getter(ListSpacesResponse.getter(ListSpacesResponse::spaces)).setter(ListSpacesResponse.setter(Builder::spaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpaceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSpacesResponse.getter(ListSpacesResponse::nextToken)).setter(ListSpacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSpacesResponse.memberNameToFieldInitializer();
    private final List<SpaceDetails> spaces;
    private final String nextToken;

    private ListSpacesResponse(BuilderImpl builder) {
        super(builder);
        this.spaces = builder.spaces;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSpaces() {
        return this.spaces != null && !(this.spaces instanceof SdkAutoConstructList);
    }

    public final List<SpaceDetails> spaces() {
        return this.spaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpaces() ? this.spaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpacesResponse)) {
            return false;
        }
        ListSpacesResponse other = (ListSpacesResponse)((Object)obj);
        return this.hasSpaces() == other.hasSpaces() && Objects.equals(this.spaces(), other.spaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSpacesResponse").add("Spaces", this.hasSpaces() ? this.spaces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Spaces": {
                return Optional.ofNullable(clazz.cast(this.spaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Spaces", SPACES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpacesResponse, T> g) {
        return obj -> g.apply((ListSpacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<SpaceDetails> spaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpacesResponse model) {
            super(model);
            this.spaces(model.spaces);
            this.nextToken(model.nextToken);
        }

        public final List<SpaceDetails.Builder> getSpaces() {
            List<SpaceDetails.Builder> result = SpaceListCopier.copyToBuilder(this.spaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpaces(Collection<SpaceDetails.BuilderImpl> spaces) {
            this.spaces = SpaceListCopier.copyFromBuilder(spaces);
        }

        @Override
        public final Builder spaces(Collection<SpaceDetails> spaces) {
            this.spaces = SpaceListCopier.copy(spaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(SpaceDetails ... spaces) {
            this.spaces(Arrays.asList(spaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaces(Consumer<SpaceDetails.Builder> ... spaces) {
            this.spaces(Stream.of(spaces).map(c -> (SpaceDetails)((SpaceDetails.Builder)SpaceDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSpacesResponse build() {
            return new ListSpacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSpacesResponse> {
        public Builder spaces(Collection<SpaceDetails> var1);

        public Builder spaces(SpaceDetails ... var1);

        public Builder spaces(Consumer<SpaceDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

