/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaSummary;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasRequest;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasResponse;

public class ListComputeQuotasIterable
implements SdkIterable<ListComputeQuotasResponse> {
    private final SageMakerClient client;
    private final ListComputeQuotasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputeQuotasIterable(SageMakerClient client, ListComputeQuotasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComputeQuotasResponseFetcher();
    }

    public Iterator<ListComputeQuotasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputeQuotaSummary> computeQuotaSummaries() {
        Function<ListComputeQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeQuotaSummaries() != null) {
                return response.computeQuotaSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputeQuotasResponseFetcher
    implements SyncPageFetcher<ListComputeQuotasResponse> {
        private ListComputeQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputeQuotasResponse nextPage(ListComputeQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListComputeQuotasIterable.this.client.listComputeQuotas(ListComputeQuotasIterable.this.firstRequest);
            }
            return ListComputeQuotasIterable.this.client.listComputeQuotas((ListComputeQuotasRequest)((Object)ListComputeQuotasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

