/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionSummary;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;

public class ListFlowDefinitionsIterable
implements SdkIterable<ListFlowDefinitionsResponse> {
    private final SageMakerClient client;
    private final ListFlowDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowDefinitionsIterable(SageMakerClient client, ListFlowDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowDefinitionsResponseFetcher();
    }

    public Iterator<ListFlowDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowDefinitionSummary> flowDefinitionSummaries() {
        Function<ListFlowDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowDefinitionSummaries() != null) {
                return response.flowDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowDefinitionsResponseFetcher
    implements SyncPageFetcher<ListFlowDefinitionsResponse> {
        private ListFlowDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowDefinitionsResponse nextPage(ListFlowDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowDefinitionsIterable.this.client.listFlowDefinitions(ListFlowDefinitionsIterable.this.firstRequest);
            }
            return ListFlowDefinitionsIterable.this.client.listFlowDefinitions((ListFlowDefinitionsRequest)((Object)ListFlowDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

