/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingPlanSummary;

public class ListTrainingPlansIterable
implements SdkIterable<ListTrainingPlansResponse> {
    private final SageMakerClient client;
    private final ListTrainingPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrainingPlansIterable(SageMakerClient client, ListTrainingPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrainingPlansResponseFetcher();
    }

    public Iterator<ListTrainingPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrainingPlanSummary> trainingPlanSummaries() {
        Function<ListTrainingPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.trainingPlanSummaries() != null) {
                return response.trainingPlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrainingPlansResponseFetcher
    implements SyncPageFetcher<ListTrainingPlansResponse> {
        private ListTrainingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListTrainingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrainingPlansResponse nextPage(ListTrainingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListTrainingPlansIterable.this.client.listTrainingPlans(ListTrainingPlansIterable.this.firstRequest);
            }
            return ListTrainingPlansIterable.this.client.listTrainingPlans((ListTrainingPlansRequest)((Object)ListTrainingPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

