/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisionedProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProvisionedProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::acceptLanguage)).setter(UpdateProvisionedProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisionedProductName)).setter(UpdateProvisionedProductRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisionedProductId)).setter(UpdateProvisionedProductRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::productId)).setter(UpdateProvisionedProductRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::productName)).setter(UpdateProvisionedProductRequest.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisioningArtifactId)).setter(UpdateProvisionedProductRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisioningArtifactName)).setter(UpdateProvisionedProductRequest.setter(Builder::provisioningArtifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::pathId)).setter(UpdateProvisionedProductRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PATH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::pathName)).setter(UpdateProvisionedProductRequest.setter(Builder::pathName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()}).build();
    private static final SdkField<List<UpdateProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisioningParameters)).setter(UpdateProvisionedProductRequest.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UpdateProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::provisioningPreferences)).setter(UpdateProvisionedProductRequest.setter(Builder::provisioningPreferences)).constructor(UpdateProvisioningPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::tags)).setter(UpdateProvisionedProductRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductRequest.getter(UpdateProvisionedProductRequest::updateToken)).setter(UpdateProvisionedProductRequest.setter(Builder::updateToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONED_PRODUCT_ID_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD, PATH_ID_FIELD, PATH_NAME_FIELD, PROVISIONING_PARAMETERS_FIELD, PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, UPDATE_TOKEN_FIELD));
    private final String acceptLanguage;
    private final String provisionedProductName;
    private final String provisionedProductId;
    private final String productId;
    private final String productName;
    private final String provisioningArtifactId;
    private final String provisioningArtifactName;
    private final String pathId;
    private final String pathName;
    private final List<UpdateProvisioningParameter> provisioningParameters;
    private final UpdateProvisioningPreferences provisioningPreferences;
    private final List<Tag> tags;
    private final String updateToken;

    private UpdateProvisionedProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.updateToken = builder.updateToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public String provisionedProductId() {
        return this.provisionedProductId;
    }

    public String productId() {
        return this.productId;
    }

    public String productName() {
        return this.productName;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String provisioningArtifactName() {
        return this.provisioningArtifactName;
    }

    public String pathId() {
        return this.pathId;
    }

    public String pathName() {
        return this.pathName;
    }

    public boolean hasProvisioningParameters() {
        return this.provisioningParameters != null && !(this.provisioningParameters instanceof SdkAutoConstructList);
    }

    public List<UpdateProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public UpdateProvisioningPreferences provisioningPreferences() {
        return this.provisioningPreferences;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String updateToken() {
        return this.updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductRequest)) {
            return false;
        }
        UpdateProvisionedProductRequest other = (UpdateProvisionedProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.provisioningArtifactName(), other.provisioningArtifactName()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.pathName(), other.pathName()) && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && Objects.equals(this.provisioningPreferences(), other.provisioningPreferences()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateToken(), other.updateToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateProvisionedProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ProductId", (Object)this.productId()).add("ProductName", (Object)this.productName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningArtifactName", (Object)this.provisioningArtifactName()).add("PathId", (Object)this.pathId()).add("PathName", (Object)this.pathName()).add("ProvisioningParameters", this.provisioningParameters()).add("ProvisioningPreferences", (Object)this.provisioningPreferences()).add("Tags", this.tags()).add("UpdateToken", (Object)this.updateToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningArtifactName": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactName()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "PathName": {
                return Optional.ofNullable(clazz.cast(this.pathName()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
            case "ProvisioningPreferences": {
                return Optional.ofNullable(clazz.cast(this.provisioningPreferences()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdateToken": {
                return Optional.ofNullable(clazz.cast(this.updateToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionedProductName;
        private String provisionedProductId;
        private String productId;
        private String productName;
        private String provisioningArtifactId;
        private String provisioningArtifactName;
        private String pathId;
        private String pathName;
        private List<UpdateProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();
        private UpdateProvisioningPreferences provisioningPreferences;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.provisionedProductName(model.provisionedProductName);
            this.provisionedProductId(model.provisionedProductId);
            this.productId(model.productId);
            this.productName(model.productName);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningArtifactName(model.provisioningArtifactName);
            this.pathId(model.pathId);
            this.pathName(model.pathName);
            this.provisioningParameters(model.provisioningParameters);
            this.provisioningPreferences(model.provisioningPreferences);
            this.tags(model.tags);
            this.updateToken(model.updateToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProductName() {
            return this.productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getProvisioningArtifactName() {
            return this.provisioningArtifactName;
        }

        @Override
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getPathName() {
            return this.pathName;
        }

        @Override
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public final Collection<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            return this.provisioningParameters != null ? (Collection)this.provisioningParameters.stream().map(UpdateProvisioningParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (UpdateProvisioningParameter)((UpdateProvisioningParameter.Builder)UpdateProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final UpdateProvisioningPreferences.Builder getProvisioningPreferences() {
            return this.provisioningPreferences != null ? this.provisioningPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningPreferences(UpdateProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final void setProvisioningPreferences(UpdateProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getUpdateToken() {
            return this.updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedProductRequest build() {
            return new UpdateProvisionedProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisionedProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisionedProductId(String var1);

        public Builder productId(String var1);

        public Builder productName(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder provisioningArtifactName(String var1);

        public Builder pathId(String var1);

        public Builder pathName(String var1);

        public Builder provisioningParameters(Collection<UpdateProvisioningParameter> var1);

        public Builder provisioningParameters(UpdateProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... var1);

        public Builder provisioningPreferences(UpdateProvisioningPreferences var1);

        default public Builder provisioningPreferences(Consumer<UpdateProvisioningPreferences.Builder> provisioningPreferences) {
            return this.provisioningPreferences((UpdateProvisioningPreferences)((UpdateProvisioningPreferences.Builder)UpdateProvisioningPreferences.builder().applyMutation(provisioningPreferences)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder updateToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

