/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningArtifactResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, CreateProvisioningArtifactResponse> {
    private static final SdkField<ProvisioningArtifactDetail> PROVISIONING_ARTIFACT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisioningArtifactDetail").getter(CreateProvisioningArtifactResponse.getter(CreateProvisioningArtifactResponse::provisioningArtifactDetail)).setter(CreateProvisioningArtifactResponse.setter(Builder::provisioningArtifactDetail)).constructor(ProvisioningArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetail").build()}).build();
    private static final SdkField<Map<String, String>> INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Info").getter(CreateProvisioningArtifactResponse.getter(CreateProvisioningArtifactResponse::info)).setter(CreateProvisioningArtifactResponse.setter(Builder::info)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateProvisioningArtifactResponse.getter(CreateProvisioningArtifactResponse::statusAsString)).setter(CreateProvisioningArtifactResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_ARTIFACT_DETAIL_FIELD, INFO_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProvisioningArtifactResponse.memberNameToFieldInitializer();
    private final ProvisioningArtifactDetail provisioningArtifactDetail;
    private final Map<String, String> info;
    private final String status;

    private CreateProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactDetail = builder.provisioningArtifactDetail;
        this.info = builder.info;
        this.status = builder.status;
    }

    public final ProvisioningArtifactDetail provisioningArtifactDetail() {
        return this.provisioningArtifactDetail;
    }

    public final boolean hasInfo() {
        return this.info != null && !(this.info instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> info() {
        return this.info;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInfo() ? this.info() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningArtifactResponse)) {
            return false;
        }
        CreateProvisioningArtifactResponse other = (CreateProvisioningArtifactResponse)((Object)obj);
        return Objects.equals(this.provisioningArtifactDetail(), other.provisioningArtifactDetail()) && this.hasInfo() == other.hasInfo() && Objects.equals(this.info(), other.info()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisioningArtifactResponse").add("ProvisioningArtifactDetail", (Object)this.provisioningArtifactDetail()).add("Info", this.hasInfo() ? this.info() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactDetail": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactDetail()));
            }
            case "Info": {
                return Optional.ofNullable(clazz.cast(this.info()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisioningArtifactDetail", PROVISIONING_ARTIFACT_DETAIL_FIELD);
        map.put("Info", INFO_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((CreateProvisioningArtifactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProvisioningArtifactDetail provisioningArtifactDetail;
        private Map<String, String> info = DefaultSdkAutoConstructMap.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningArtifactResponse model) {
            super(model);
            this.provisioningArtifactDetail(model.provisioningArtifactDetail);
            this.info(model.info);
            this.status(model.status);
        }

        public final ProvisioningArtifactDetail.Builder getProvisioningArtifactDetail() {
            return this.provisioningArtifactDetail != null ? this.provisioningArtifactDetail.toBuilder() : null;
        }

        public final void setProvisioningArtifactDetail(ProvisioningArtifactDetail.BuilderImpl provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail != null ? provisioningArtifactDetail.build() : null;
        }

        @Override
        public final Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail;
            return this;
        }

        public final Map<String, String> getInfo() {
            if (this.info instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.info;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateProvisioningArtifactResponse build() {
            return new CreateProvisioningArtifactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningArtifactResponse> {
        public Builder provisioningArtifactDetail(ProvisioningArtifactDetail var1);

        default public Builder provisioningArtifactDetail(Consumer<ProvisioningArtifactDetail.Builder> provisioningArtifactDetail) {
            return this.provisioningArtifactDetail((ProvisioningArtifactDetail)((ProvisioningArtifactDetail.Builder)ProvisioningArtifactDetail.builder().applyMutation(provisioningArtifactDetail)).build());
        }

        public Builder info(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

