/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.services.ses.waiters.SesWaiter;
import software.amazon.awssdk.services.ses.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultSesWaiter
implements SesWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final SesClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetIdentityVerificationAttributesResponse> identityExistsWaiter;

    private DefaultSesWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SesClient)SesClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.identityExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetIdentityVerificationAttributesResponse.class).acceptors(DefaultSesWaiter.identityExistsWaiterAcceptors())).overrideConfiguration(DefaultSesWaiter.identityExistsWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetIdentityVerificationAttributesResponse> waitUntilIdentityExists(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        return this.identityExistsWaiter.run(() -> this.client.getIdentityVerificationAttributes(this.applyWaitersUserAgent(getIdentityVerificationAttributesRequest)));
    }

    @Override
    public WaiterResponse<GetIdentityVerificationAttributesResponse> waitUntilIdentityExists(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.identityExistsWaiter.run(() -> this.client.getIdentityVerificationAttributes(this.applyWaitersUserAgent(getIdentityVerificationAttributesRequest)), DefaultSesWaiter.identityExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetIdentityVerificationAttributesResponse>> identityExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetIdentityVerificationAttributesResponse>> result = new ArrayList<WaiterAcceptor<? super GetIdentityVerificationAttributesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VerificationAttributes").wildcard().field("VerificationStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Success"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration identityExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SesWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SesRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SesRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SesWaiter.Builder {
        private SesClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public SesWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SesWaiter.Builder client(SesClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SesWaiter build() {
            return new DefaultSesWaiter(this);
        }
    }
}

