/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.services.ses.model.VerificationAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityVerificationAttributesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
    private static final SdkField<Map<String, IdentityVerificationAttributes>> VERIFICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("VerificationAttributes").getter(GetIdentityVerificationAttributesResponse.getter(GetIdentityVerificationAttributesResponse::verificationAttributes)).setter(GetIdentityVerificationAttributesResponse.setter(Builder::verificationAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityVerificationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdentityVerificationAttributesResponse.memberNameToFieldInitializer();
    private final Map<String, IdentityVerificationAttributes> verificationAttributes;

    private GetIdentityVerificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.verificationAttributes = builder.verificationAttributes;
    }

    public final boolean hasVerificationAttributes() {
        return this.verificationAttributes != null && !(this.verificationAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, IdentityVerificationAttributes> verificationAttributes() {
        return this.verificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerificationAttributes() ? this.verificationAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesResponse)) {
            return false;
        }
        GetIdentityVerificationAttributesResponse other = (GetIdentityVerificationAttributesResponse)((Object)obj);
        return this.hasVerificationAttributes() == other.hasVerificationAttributes() && Objects.equals(this.verificationAttributes(), other.verificationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityVerificationAttributesResponse").add("VerificationAttributes", this.hasVerificationAttributes() ? this.verificationAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerificationAttributes": {
                return Optional.ofNullable(clazz.cast(this.verificationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, IdentityVerificationAttributes>>> map = new HashMap<String, SdkField<Map<String, IdentityVerificationAttributes>>>();
        map.put("VerificationAttributes", VERIFICATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityVerificationAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityVerificationAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityVerificationAttributes> verificationAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesResponse model) {
            super(model);
            this.verificationAttributes(model.verificationAttributes);
        }

        public final Map<String, IdentityVerificationAttributes.Builder> getVerificationAttributes() {
            Map<String, IdentityVerificationAttributes.Builder> result = VerificationAttributesCopier.copyToBuilder(this.verificationAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVerificationAttributes(Map<String, IdentityVerificationAttributes.BuilderImpl> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copyFromBuilder(verificationAttributes);
        }

        @Override
        public final Builder verificationAttributes(Map<String, IdentityVerificationAttributes> verificationAttributes) {
            this.verificationAttributes = VerificationAttributesCopier.copy(verificationAttributes);
            return this;
        }

        @Override
        public GetIdentityVerificationAttributesResponse build() {
            return new GetIdentityVerificationAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityVerificationAttributesResponse> {
        public Builder verificationAttributes(Map<String, IdentityVerificationAttributes> var1);
    }
}

