/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.BulkEmailDestination;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationListCopier;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBulkTemplatedEmailRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SendBulkTemplatedEmailRequest> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::source)).setter(SendBulkTemplatedEmailRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::sourceArn)).setter(SendBulkTemplatedEmailRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplyToAddresses").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::replyToAddresses)).setter(SendBulkTemplatedEmailRequest.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnPath").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::returnPath)).setter(SendBulkTemplatedEmailRequest.setter(Builder::returnPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPath").build()}).build();
    private static final SdkField<String> RETURN_PATH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnPathArn").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::returnPathArn)).setter(SendBulkTemplatedEmailRequest.setter(Builder::returnPathArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPathArn").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::configurationSetName)).setter(SendBulkTemplatedEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<List<MessageTag>> DEFAULT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultTags").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::defaultTags)).setter(SendBulkTemplatedEmailRequest.setter(Builder::defaultTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Template").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::template)).setter(SendBulkTemplatedEmailRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::templateArn)).setter(SendBulkTemplatedEmailRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> DEFAULT_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultTemplateData").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::defaultTemplateData)).setter(SendBulkTemplatedEmailRequest.setter(Builder::defaultTemplateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTemplateData").build()}).build();
    private static final SdkField<List<BulkEmailDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(SendBulkTemplatedEmailRequest.getter(SendBulkTemplatedEmailRequest::destinations)).setter(SendBulkTemplatedEmailRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkEmailDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, SOURCE_ARN_FIELD, REPLY_TO_ADDRESSES_FIELD, RETURN_PATH_FIELD, RETURN_PATH_ARN_FIELD, CONFIGURATION_SET_NAME_FIELD, DEFAULT_TAGS_FIELD, TEMPLATE_FIELD, TEMPLATE_ARN_FIELD, DEFAULT_TEMPLATE_DATA_FIELD, DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendBulkTemplatedEmailRequest.memberNameToFieldInitializer();
    private final String source;
    private final String sourceArn;
    private final List<String> replyToAddresses;
    private final String returnPath;
    private final String returnPathArn;
    private final String configurationSetName;
    private final List<MessageTag> defaultTags;
    private final String template;
    private final String templateArn;
    private final String defaultTemplateData;
    private final List<BulkEmailDestination> destinations;

    private SendBulkTemplatedEmailRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.sourceArn = builder.sourceArn;
        this.replyToAddresses = builder.replyToAddresses;
        this.returnPath = builder.returnPath;
        this.returnPathArn = builder.returnPathArn;
        this.configurationSetName = builder.configurationSetName;
        this.defaultTags = builder.defaultTags;
        this.template = builder.template;
        this.templateArn = builder.templateArn;
        this.defaultTemplateData = builder.defaultTemplateData;
        this.destinations = builder.destinations;
    }

    public final String source() {
        return this.source;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && !(this.replyToAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public final String returnPath() {
        return this.returnPath;
    }

    public final String returnPathArn() {
        return this.returnPathArn;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final boolean hasDefaultTags() {
        return this.defaultTags != null && !(this.defaultTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> defaultTags() {
        return this.defaultTags;
    }

    public final String template() {
        return this.template;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String defaultTemplateData() {
        return this.defaultTemplateData;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<BulkEmailDestination> destinations() {
        return this.destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplyToAddresses() ? this.replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultTags() ? this.defaultTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailRequest)) {
            return false;
        }
        SendBulkTemplatedEmailRequest other = (SendBulkTemplatedEmailRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceArn(), other.sourceArn()) && this.hasReplyToAddresses() == other.hasReplyToAddresses() && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.returnPath(), other.returnPath()) && Objects.equals(this.returnPathArn(), other.returnPathArn()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && this.hasDefaultTags() == other.hasDefaultTags() && Objects.equals(this.defaultTags(), other.defaultTags()) && Objects.equals(this.template(), other.template()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.defaultTemplateData(), other.defaultTemplateData()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"SendBulkTemplatedEmailRequest").add("Source", (Object)this.source()).add("SourceArn", (Object)this.sourceArn()).add("ReplyToAddresses", this.hasReplyToAddresses() ? this.replyToAddresses() : null).add("ReturnPath", (Object)this.returnPath()).add("ReturnPathArn", (Object)this.returnPathArn()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("DefaultTags", this.hasDefaultTags() ? this.defaultTags() : null).add("Template", (Object)this.template()).add("TemplateArn", (Object)this.templateArn()).add("DefaultTemplateData", (Object)this.defaultTemplateData()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "ReturnPath": {
                return Optional.ofNullable(clazz.cast(this.returnPath()));
            }
            case "ReturnPathArn": {
                return Optional.ofNullable(clazz.cast(this.returnPathArn()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "DefaultTags": {
                return Optional.ofNullable(clazz.cast(this.defaultTags()));
            }
            case "Template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "DefaultTemplateData": {
                return Optional.ofNullable(clazz.cast(this.defaultTemplateData()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Source", SOURCE_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("ReplyToAddresses", REPLY_TO_ADDRESSES_FIELD);
        map.put("ReturnPath", RETURN_PATH_FIELD);
        map.put("ReturnPathArn", RETURN_PATH_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("DefaultTags", DEFAULT_TAGS_FIELD);
        map.put("Template", TEMPLATE_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("DefaultTemplateData", DEFAULT_TEMPLATE_DATA_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendBulkTemplatedEmailRequest, T> g) {
        return obj -> g.apply((SendBulkTemplatedEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String source;
        private String sourceArn;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private String returnPath;
        private String returnPathArn;
        private String configurationSetName;
        private List<MessageTag> defaultTags = DefaultSdkAutoConstructList.getInstance();
        private String template;
        private String templateArn;
        private String defaultTemplateData;
        private List<BulkEmailDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailRequest model) {
            super(model);
            this.source(model.source);
            this.sourceArn(model.sourceArn);
            this.replyToAddresses(model.replyToAddresses);
            this.returnPath(model.returnPath);
            this.returnPathArn(model.returnPathArn);
            this.configurationSetName(model.configurationSetName);
            this.defaultTags(model.defaultTags);
            this.template(model.template);
            this.templateArn(model.templateArn);
            this.defaultTemplateData(model.defaultTemplateData);
            this.destinations(model.destinations);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final Collection<String> getReplyToAddresses() {
            if (this.replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replyToAddresses;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final String getReturnPath() {
            return this.returnPath;
        }

        public final void setReturnPath(String returnPath) {
            this.returnPath = returnPath;
        }

        @Override
        public final Builder returnPath(String returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final List<MessageTag.Builder> getDefaultTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.defaultTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultTags(Collection<MessageTag.BuilderImpl> defaultTags) {
            this.defaultTags = MessageTagListCopier.copyFromBuilder(defaultTags);
        }

        @Override
        public final Builder defaultTags(Collection<MessageTag> defaultTags) {
            this.defaultTags = MessageTagListCopier.copy(defaultTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultTags(MessageTag ... defaultTags) {
            this.defaultTags(Arrays.asList(defaultTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultTags(Consumer<MessageTag.Builder> ... defaultTags) {
            this.defaultTags(Stream.of(defaultTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTemplate() {
            return this.template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getDefaultTemplateData() {
            return this.defaultTemplateData;
        }

        public final void setDefaultTemplateData(String defaultTemplateData) {
            this.defaultTemplateData = defaultTemplateData;
        }

        @Override
        public final Builder defaultTemplateData(String defaultTemplateData) {
            this.defaultTemplateData = defaultTemplateData;
            return this;
        }

        public final List<BulkEmailDestination.Builder> getDestinations() {
            List<BulkEmailDestination.Builder> result = BulkEmailDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<BulkEmailDestination.BuilderImpl> destinations) {
            this.destinations = BulkEmailDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<BulkEmailDestination> destinations) {
            this.destinations = BulkEmailDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(BulkEmailDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<BulkEmailDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (BulkEmailDestination)((BulkEmailDestination.Builder)BulkEmailDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendBulkTemplatedEmailRequest build() {
            return new SendBulkTemplatedEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBulkTemplatedEmailRequest> {
        public Builder source(String var1);

        public Builder sourceArn(String var1);

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder returnPath(String var1);

        public Builder returnPathArn(String var1);

        public Builder configurationSetName(String var1);

        public Builder defaultTags(Collection<MessageTag> var1);

        public Builder defaultTags(MessageTag ... var1);

        public Builder defaultTags(Consumer<MessageTag.Builder> ... var1);

        public Builder template(String var1);

        public Builder templateArn(String var1);

        public Builder defaultTemplateData(String var1);

        public Builder destinations(Collection<BulkEmailDestination> var1);

        public Builder destinations(BulkEmailDestination ... var1);

        public Builder destinations(Consumer<BulkEmailDestination.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

