/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns CNAME records that you must publish to the DNS server of your domain to set up Easy DKIM with Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyDomainDkimResponse extends SesResponse implements
        ToCopyableBuilder<VerifyDomainDkimResponse.Builder, VerifyDomainDkimResponse> {
    private static final SdkField<List<String>> DKIM_TOKENS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VerifyDomainDkimResponse::dkimTokens))
            .setter(setter(Builder::dkimTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_TOKENS_FIELD));

    private final List<String> dkimTokens;

    private VerifyDomainDkimResponse(BuilderImpl builder) {
        super(builder);
        this.dkimTokens = builder.dkimTokens;
    }

    /**
     * <p>
     * A set of character strings that represent the domain's identity. If the identity is an email address, the tokens
     * represent the domain of that address.
     * </p>
     * <p>
     * Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by Amazon
     * SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection process might
     * take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email originating from that
     * domain. (This only applies to domain identities, not email address identities.)
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of character strings that represent the domain's identity. If the identity is an email address, the
     *         tokens represent the domain of that address.</p>
     *         <p>
     *         Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted
     *         by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This
     *         detection process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign
     *         email originating from that domain. (This only applies to domain identities, not email address
     *         identities.)
     *         </p>
     *         <p>
     *         For more information about creating DNS records using DKIM tokens, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
     *         Guide</a>.
     */
    public List<String> dkimTokens() {
        return dkimTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dkimTokens());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimResponse)) {
            return false;
        }
        VerifyDomainDkimResponse other = (VerifyDomainDkimResponse) obj;
        return Objects.equals(dkimTokens(), other.dkimTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VerifyDomainDkimResponse").add("DkimTokens", dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DkimTokens":
            return Optional.ofNullable(clazz.cast(dkimTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDomainDkimResponse, T> g) {
        return obj -> g.apply((VerifyDomainDkimResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, VerifyDomainDkimResponse> {
        /**
         * <p>
         * A set of character strings that represent the domain's identity. If the identity is an email address, the
         * tokens represent the domain of that address.
         * </p>
         * <p>
         * Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by
         * Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
         * process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email
         * originating from that domain. (This only applies to domain identities, not email address identities.)
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, see the <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. If the identity is an email address,
         *        the tokens represent the domain of that address.</p>
         *        <p>
         *        Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are
         *        hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records.
         *        This detection process might take up to 72 hours. After successful detection, Amazon SES is able to
         *        DKIM-sign email originating from that domain. (This only applies to domain identities, not email
         *        address identities.)
         *        </p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, see the <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(Collection<String> dkimTokens);

        /**
         * <p>
         * A set of character strings that represent the domain's identity. If the identity is an email address, the
         * tokens represent the domain of that address.
         * </p>
         * <p>
         * Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are hosted by
         * Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records. This detection
         * process might take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign email
         * originating from that domain. (This only applies to domain identities, not email address identities.)
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, see the <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer Guide</a>.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. If the identity is an email address,
         *        the tokens represent the domain of that address.</p>
         *        <p>
         *        Using these tokens, you need to create DNS CNAME records that point to DKIM public keys that are
         *        hosted by Amazon SES. Amazon Web Services eventually detects that you've updated your DNS records.
         *        This detection process might take up to 72 hours. After successful detection, Amazon SES is able to
         *        DKIM-sign email originating from that domain. (This only applies to domain identities, not email
         *        address identities.)
         *        </p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, see the <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Amazon SES Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(String... dkimTokens);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimResponse model) {
            super(model);
            dkimTokens(model.dkimTokens);
        }

        public final Collection<String> getDkimTokens() {
            return dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String... dkimTokens) {
            dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @Override
        public VerifyDomainDkimResponse build() {
            return new VerifyDomainDkimResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
