/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.BulkEmailContent;
import software.amazon.awssdk.services.sesv2.model.BulkEmailEntry;
import software.amazon.awssdk.services.sesv2.model.BulkEmailEntryListCopier;
import software.amazon.awssdk.services.sesv2.model.EmailAddressListCopier;
import software.amazon.awssdk.services.sesv2.model.MessageTag;
import software.amazon.awssdk.services.sesv2.model.MessageTagListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBulkEmailRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, SendBulkEmailRequest> {
    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddress").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::fromEmailAddress)).setter(SendBulkEmailRequest.setter(Builder::fromEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<String> FROM_EMAIL_ADDRESS_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromEmailAddressIdentityArn").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::fromEmailAddressIdentityArn)).setter(SendBulkEmailRequest.setter(Builder::fromEmailAddressIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddressIdentityArn").build()}).build();
    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplyToAddresses").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::replyToAddresses)).setter(SendBulkEmailRequest.setter(Builder::replyToAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackForwardingEmailAddress").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::feedbackForwardingEmailAddress)).setter(SendBulkEmailRequest.setter(Builder::feedbackForwardingEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddress").build()}).build();
    private static final SdkField<String> FEEDBACK_FORWARDING_EMAIL_ADDRESS_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackForwardingEmailAddressIdentityArn").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::feedbackForwardingEmailAddressIdentityArn)).setter(SendBulkEmailRequest.setter(Builder::feedbackForwardingEmailAddressIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingEmailAddressIdentityArn").build()}).build();
    private static final SdkField<List<MessageTag>> DEFAULT_EMAIL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultEmailTags").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::defaultEmailTags)).setter(SendBulkEmailRequest.setter(Builder::defaultEmailTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEmailTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BulkEmailContent> DEFAULT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultContent").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::defaultContent)).setter(SendBulkEmailRequest.setter(Builder::defaultContent)).constructor(BulkEmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultContent").build()}).build();
    private static final SdkField<List<BulkEmailEntry>> BULK_EMAIL_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BulkEmailEntries").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::bulkEmailEntries)).setter(SendBulkEmailRequest.setter(Builder::bulkEmailEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkEmailEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkEmailEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(SendBulkEmailRequest.getter(SendBulkEmailRequest::configurationSetName)).setter(SendBulkEmailRequest.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_EMAIL_ADDRESS_FIELD, FROM_EMAIL_ADDRESS_IDENTITY_ARN_FIELD, REPLY_TO_ADDRESSES_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_FIELD, FEEDBACK_FORWARDING_EMAIL_ADDRESS_IDENTITY_ARN_FIELD, DEFAULT_EMAIL_TAGS_FIELD, DEFAULT_CONTENT_FIELD, BULK_EMAIL_ENTRIES_FIELD, CONFIGURATION_SET_NAME_FIELD));
    private final String fromEmailAddress;
    private final String fromEmailAddressIdentityArn;
    private final List<String> replyToAddresses;
    private final String feedbackForwardingEmailAddress;
    private final String feedbackForwardingEmailAddressIdentityArn;
    private final List<MessageTag> defaultEmailTags;
    private final BulkEmailContent defaultContent;
    private final List<BulkEmailEntry> bulkEmailEntries;
    private final String configurationSetName;

    private SendBulkEmailRequest(BuilderImpl builder) {
        super(builder);
        this.fromEmailAddress = builder.fromEmailAddress;
        this.fromEmailAddressIdentityArn = builder.fromEmailAddressIdentityArn;
        this.replyToAddresses = builder.replyToAddresses;
        this.feedbackForwardingEmailAddress = builder.feedbackForwardingEmailAddress;
        this.feedbackForwardingEmailAddressIdentityArn = builder.feedbackForwardingEmailAddressIdentityArn;
        this.defaultEmailTags = builder.defaultEmailTags;
        this.defaultContent = builder.defaultContent;
        this.bulkEmailEntries = builder.bulkEmailEntries;
        this.configurationSetName = builder.configurationSetName;
    }

    public final String fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final String fromEmailAddressIdentityArn() {
        return this.fromEmailAddressIdentityArn;
    }

    public final boolean hasReplyToAddresses() {
        return this.replyToAddresses != null && !(this.replyToAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public final String feedbackForwardingEmailAddress() {
        return this.feedbackForwardingEmailAddress;
    }

    public final String feedbackForwardingEmailAddressIdentityArn() {
        return this.feedbackForwardingEmailAddressIdentityArn;
    }

    public final boolean hasDefaultEmailTags() {
        return this.defaultEmailTags != null && !(this.defaultEmailTags instanceof SdkAutoConstructList);
    }

    public final List<MessageTag> defaultEmailTags() {
        return this.defaultEmailTags;
    }

    public final BulkEmailContent defaultContent() {
        return this.defaultContent;
    }

    public final boolean hasBulkEmailEntries() {
        return this.bulkEmailEntries != null && !(this.bulkEmailEntries instanceof SdkAutoConstructList);
    }

    public final List<BulkEmailEntry> bulkEmailEntries() {
        return this.bulkEmailEntries;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddressIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplyToAddresses() ? this.replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackForwardingEmailAddressIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultEmailTags() ? this.defaultEmailTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBulkEmailEntries() ? this.bulkEmailEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkEmailRequest)) {
            return false;
        }
        SendBulkEmailRequest other = (SendBulkEmailRequest)((Object)obj);
        return Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.fromEmailAddressIdentityArn(), other.fromEmailAddressIdentityArn()) && this.hasReplyToAddresses() == other.hasReplyToAddresses() && Objects.equals(this.replyToAddresses(), other.replyToAddresses()) && Objects.equals(this.feedbackForwardingEmailAddress(), other.feedbackForwardingEmailAddress()) && Objects.equals(this.feedbackForwardingEmailAddressIdentityArn(), other.feedbackForwardingEmailAddressIdentityArn()) && this.hasDefaultEmailTags() == other.hasDefaultEmailTags() && Objects.equals(this.defaultEmailTags(), other.defaultEmailTags()) && Objects.equals(this.defaultContent(), other.defaultContent()) && this.hasBulkEmailEntries() == other.hasBulkEmailEntries() && Objects.equals(this.bulkEmailEntries(), other.bulkEmailEntries()) && Objects.equals(this.configurationSetName(), other.configurationSetName());
    }

    public final String toString() {
        return ToString.builder((String)"SendBulkEmailRequest").add("FromEmailAddress", (Object)this.fromEmailAddress()).add("FromEmailAddressIdentityArn", (Object)this.fromEmailAddressIdentityArn()).add("ReplyToAddresses", this.hasReplyToAddresses() ? this.replyToAddresses() : null).add("FeedbackForwardingEmailAddress", (Object)this.feedbackForwardingEmailAddress()).add("FeedbackForwardingEmailAddressIdentityArn", (Object)this.feedbackForwardingEmailAddressIdentityArn()).add("DefaultEmailTags", this.hasDefaultEmailTags() ? this.defaultEmailTags() : null).add("DefaultContent", (Object)this.defaultContent()).add("BulkEmailEntries", this.hasBulkEmailEntries() ? this.bulkEmailEntries() : null).add("ConfigurationSetName", (Object)this.configurationSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "FromEmailAddressIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddressIdentityArn()));
            }
            case "ReplyToAddresses": {
                return Optional.ofNullable(clazz.cast(this.replyToAddresses()));
            }
            case "FeedbackForwardingEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingEmailAddress()));
            }
            case "FeedbackForwardingEmailAddressIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.feedbackForwardingEmailAddressIdentityArn()));
            }
            case "DefaultEmailTags": {
                return Optional.ofNullable(clazz.cast(this.defaultEmailTags()));
            }
            case "DefaultContent": {
                return Optional.ofNullable(clazz.cast(this.defaultContent()));
            }
            case "BulkEmailEntries": {
                return Optional.ofNullable(clazz.cast(this.bulkEmailEntries()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBulkEmailRequest, T> g) {
        return obj -> g.apply((SendBulkEmailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String fromEmailAddress;
        private String fromEmailAddressIdentityArn;
        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();
        private String feedbackForwardingEmailAddress;
        private String feedbackForwardingEmailAddressIdentityArn;
        private List<MessageTag> defaultEmailTags = DefaultSdkAutoConstructList.getInstance();
        private BulkEmailContent defaultContent;
        private List<BulkEmailEntry> bulkEmailEntries = DefaultSdkAutoConstructList.getInstance();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkEmailRequest model) {
            super(model);
            this.fromEmailAddress(model.fromEmailAddress);
            this.fromEmailAddressIdentityArn(model.fromEmailAddressIdentityArn);
            this.replyToAddresses(model.replyToAddresses);
            this.feedbackForwardingEmailAddress(model.feedbackForwardingEmailAddress);
            this.feedbackForwardingEmailAddressIdentityArn(model.feedbackForwardingEmailAddressIdentityArn);
            this.defaultEmailTags(model.defaultEmailTags);
            this.defaultContent(model.defaultContent);
            this.bulkEmailEntries(model.bulkEmailEntries);
            this.configurationSetName(model.configurationSetName);
        }

        public final String getFromEmailAddress() {
            return this.fromEmailAddress;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        @Override
        @Transient
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getFromEmailAddressIdentityArn() {
            return this.fromEmailAddressIdentityArn;
        }

        public final void setFromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
            this.fromEmailAddressIdentityArn = fromEmailAddressIdentityArn;
        }

        @Override
        @Transient
        public final Builder fromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
            this.fromEmailAddressIdentityArn = fromEmailAddressIdentityArn;
            return this;
        }

        public final Collection<String> getReplyToAddresses() {
            if (this.replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replyToAddresses;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
        }

        @Override
        @Transient
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = EmailAddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            this.replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final String getFeedbackForwardingEmailAddress() {
            return this.feedbackForwardingEmailAddress;
        }

        public final void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
        }

        @Override
        @Transient
        public final Builder feedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
            this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
            return this;
        }

        public final String getFeedbackForwardingEmailAddressIdentityArn() {
            return this.feedbackForwardingEmailAddressIdentityArn;
        }

        public final void setFeedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
            this.feedbackForwardingEmailAddressIdentityArn = feedbackForwardingEmailAddressIdentityArn;
        }

        @Override
        @Transient
        public final Builder feedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
            this.feedbackForwardingEmailAddressIdentityArn = feedbackForwardingEmailAddressIdentityArn;
            return this;
        }

        public final List<MessageTag.Builder> getDefaultEmailTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.defaultEmailTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultEmailTags(Collection<MessageTag.BuilderImpl> defaultEmailTags) {
            this.defaultEmailTags = MessageTagListCopier.copyFromBuilder(defaultEmailTags);
        }

        @Override
        @Transient
        public final Builder defaultEmailTags(Collection<MessageTag> defaultEmailTags) {
            this.defaultEmailTags = MessageTagListCopier.copy(defaultEmailTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultEmailTags(MessageTag ... defaultEmailTags) {
            this.defaultEmailTags(Arrays.asList(defaultEmailTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultEmailTags(Consumer<MessageTag.Builder> ... defaultEmailTags) {
            this.defaultEmailTags(Stream.of(defaultEmailTags).map(c -> (MessageTag)((MessageTag.Builder)MessageTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BulkEmailContent.Builder getDefaultContent() {
            return this.defaultContent != null ? this.defaultContent.toBuilder() : null;
        }

        public final void setDefaultContent(BulkEmailContent.BuilderImpl defaultContent) {
            this.defaultContent = defaultContent != null ? defaultContent.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultContent(BulkEmailContent defaultContent) {
            this.defaultContent = defaultContent;
            return this;
        }

        public final List<BulkEmailEntry.Builder> getBulkEmailEntries() {
            List<BulkEmailEntry.Builder> result = BulkEmailEntryListCopier.copyToBuilder(this.bulkEmailEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBulkEmailEntries(Collection<BulkEmailEntry.BuilderImpl> bulkEmailEntries) {
            this.bulkEmailEntries = BulkEmailEntryListCopier.copyFromBuilder(bulkEmailEntries);
        }

        @Override
        @Transient
        public final Builder bulkEmailEntries(Collection<BulkEmailEntry> bulkEmailEntries) {
            this.bulkEmailEntries = BulkEmailEntryListCopier.copy(bulkEmailEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bulkEmailEntries(BulkEmailEntry ... bulkEmailEntries) {
            this.bulkEmailEntries(Arrays.asList(bulkEmailEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bulkEmailEntries(Consumer<BulkEmailEntry.Builder> ... bulkEmailEntries) {
            this.bulkEmailEntries(Stream.of(bulkEmailEntries).map(c -> (BulkEmailEntry)((BulkEmailEntry.Builder)BulkEmailEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        @Transient
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendBulkEmailRequest build() {
            return new SendBulkEmailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBulkEmailRequest> {
        public Builder fromEmailAddress(String var1);

        public Builder fromEmailAddressIdentityArn(String var1);

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder feedbackForwardingEmailAddress(String var1);

        public Builder feedbackForwardingEmailAddressIdentityArn(String var1);

        public Builder defaultEmailTags(Collection<MessageTag> var1);

        public Builder defaultEmailTags(MessageTag ... var1);

        public Builder defaultEmailTags(Consumer<MessageTag.Builder> ... var1);

        public Builder defaultContent(BulkEmailContent var1);

        default public Builder defaultContent(Consumer<BulkEmailContent.Builder> defaultContent) {
            return this.defaultContent((BulkEmailContent)((BulkEmailContent.Builder)BulkEmailContent.builder().applyMutation(defaultContent)).build());
        }

        public Builder bulkEmailEntries(Collection<BulkEmailEntry> var1);

        public Builder bulkEmailEntries(BulkEmailEntry ... var1);

        public Builder bulkEmailEntries(Consumer<BulkEmailEntry.Builder> ... var1);

        public Builder configurationSetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

