/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2Client;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;

public class ListDedicatedIpPoolsIterable
implements SdkIterable<ListDedicatedIpPoolsResponse> {
    private final SesV2Client client;
    private final ListDedicatedIpPoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDedicatedIpPoolsIterable(SesV2Client client, ListDedicatedIpPoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDedicatedIpPoolsResponseFetcher();
    }

    public Iterator<ListDedicatedIpPoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDedicatedIpPoolsResponseFetcher
    implements SyncPageFetcher<ListDedicatedIpPoolsResponse> {
        private ListDedicatedIpPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDedicatedIpPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDedicatedIpPoolsResponse nextPage(ListDedicatedIpPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDedicatedIpPoolsIterable.this.client.listDedicatedIpPools(ListDedicatedIpPoolsIterable.this.firstRequest);
            }
            return ListDedicatedIpPoolsIterable.this.client.listDedicatedIpPools((ListDedicatedIpPoolsRequest)((Object)ListDedicatedIpPoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

