/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InspectionDataResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InspectionDataResponse> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(InspectionDataResponse.getter(InspectionDataResponse::protocol)).setter(InspectionDataResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(InspectionDataResponse.getter(InspectionDataResponse::statusCode)).setter(InspectionDataResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(InspectionDataResponse.getter(InspectionDataResponse::statusMessage)).setter(InspectionDataResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("headers").getter(InspectionDataResponse.getter(InspectionDataResponse::headers)).setter(InspectionDataResponse.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(InspectionDataResponse.getter(InspectionDataResponse::body)).setter(InspectionDataResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, HEADERS_FIELD, BODY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String statusCodeValue;
    private final String statusMessage;
    private final String headers;
    private final String body;

    private InspectionDataResponse(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String statusCode() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String headers() {
        return this.headers;
    }

    public final String body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionDataResponse)) {
            return false;
        }
        InspectionDataResponse other = (InspectionDataResponse)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"InspectionDataResponse").add("Protocol", (Object)this.protocol()).add("StatusCode", (Object)this.statusCode()).add("StatusMessage", (Object)this.statusMessage()).add("Headers", (Object)this.headers()).add("Body", (Object)this.body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InspectionDataResponse, T> g) {
        return obj -> g.apply((InspectionDataResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private String statusCodeValue;
        private String statusMessage;
        private String headers;
        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionDataResponse model) {
            this.protocol(model.protocol);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.headers(model.headers);
            this.body(model.body);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getHeaders() {
            return this.headers;
        }

        public final void setHeaders(String headers) {
            this.headers = headers;
        }

        @Override
        public final Builder headers(String headers) {
            this.headers = headers;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public InspectionDataResponse build() {
            return new InspectionDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InspectionDataResponse> {
        public Builder protocol(String var1);

        public Builder statusCode(String var1);

        public Builder statusMessage(String var1);

        public Builder headers(String var1);

        public Builder body(String var1);
    }
}

