/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.MockErrorOutput;
import software.amazon.awssdk.services.sfn.model.MockResponseValidationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MockInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MockInput> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(MockInput.getter(MockInput::result)).setter(MockInput.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<MockErrorOutput> ERROR_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorOutput").getter(MockInput.getter(MockInput::errorOutput)).setter(MockInput.setter(Builder::errorOutput)).constructor(MockErrorOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorOutput").build()}).build();
    private static final SdkField<String> FIELD_VALIDATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldValidationMode").getter(MockInput.getter(MockInput::fieldValidationModeAsString)).setter(MockInput.setter(Builder::fieldValidationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldValidationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, ERROR_OUTPUT_FIELD, FIELD_VALIDATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MockInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String result;
    private final MockErrorOutput errorOutput;
    private final String fieldValidationMode;

    private MockInput(BuilderImpl builder) {
        this.result = builder.result;
        this.errorOutput = builder.errorOutput;
        this.fieldValidationMode = builder.fieldValidationMode;
    }

    public final String result() {
        return this.result;
    }

    public final MockErrorOutput errorOutput() {
        return this.errorOutput;
    }

    public final MockResponseValidationMode fieldValidationMode() {
        return MockResponseValidationMode.fromValue(this.fieldValidationMode);
    }

    public final String fieldValidationModeAsString() {
        return this.fieldValidationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValidationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MockInput)) {
            return false;
        }
        MockInput other = (MockInput)obj;
        return Objects.equals(this.result(), other.result()) && Objects.equals(this.errorOutput(), other.errorOutput()) && Objects.equals(this.fieldValidationModeAsString(), other.fieldValidationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MockInput").add("Result", (Object)(this.result() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorOutput", (Object)this.errorOutput()).add("FieldValidationMode", (Object)this.fieldValidationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "errorOutput": {
                return Optional.ofNullable(clazz.cast(this.errorOutput()));
            }
            case "fieldValidationMode": {
                return Optional.ofNullable(clazz.cast(this.fieldValidationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", RESULT_FIELD);
        map.put("errorOutput", ERROR_OUTPUT_FIELD);
        map.put("fieldValidationMode", FIELD_VALIDATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MockInput, T> g) {
        return obj -> g.apply((MockInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String result;
        private MockErrorOutput errorOutput;
        private String fieldValidationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MockInput model) {
            this.result(model.result);
            this.errorOutput(model.errorOutput);
            this.fieldValidationMode(model.fieldValidationMode);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final MockErrorOutput.Builder getErrorOutput() {
            return this.errorOutput != null ? this.errorOutput.toBuilder() : null;
        }

        public final void setErrorOutput(MockErrorOutput.BuilderImpl errorOutput) {
            this.errorOutput = errorOutput != null ? errorOutput.build() : null;
        }

        @Override
        public final Builder errorOutput(MockErrorOutput errorOutput) {
            this.errorOutput = errorOutput;
            return this;
        }

        public final String getFieldValidationMode() {
            return this.fieldValidationMode;
        }

        public final void setFieldValidationMode(String fieldValidationMode) {
            this.fieldValidationMode = fieldValidationMode;
        }

        @Override
        public final Builder fieldValidationMode(String fieldValidationMode) {
            this.fieldValidationMode = fieldValidationMode;
            return this;
        }

        @Override
        public final Builder fieldValidationMode(MockResponseValidationMode fieldValidationMode) {
            this.fieldValidationMode(fieldValidationMode == null ? null : fieldValidationMode.toString());
            return this;
        }

        public MockInput build() {
            return new MockInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MockInput> {
        public Builder result(String var1);

        public Builder errorOutput(MockErrorOutput var1);

        default public Builder errorOutput(Consumer<MockErrorOutput.Builder> errorOutput) {
            return this.errorOutput((MockErrorOutput)((MockErrorOutput.Builder)MockErrorOutput.builder().applyMutation(errorOutput)).build());
        }

        public Builder fieldValidationMode(String var1);

        public Builder fieldValidationMode(MockResponseValidationMode var1);
    }
}

