/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.sms.model.CreateAppRequest;
import software.amazon.awssdk.services.sms.model.CreateAppResponse;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.DeleteAppRequest;
import software.amazon.awssdk.services.sms.model.DeleteAppResponse;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.DeleteReplicationJobResponse;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.DeleteServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorRequest;
import software.amazon.awssdk.services.sms.model.DisassociateConnectorResponse;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest;
import software.amazon.awssdk.services.sms.model.GenerateChangeSetResponse;
import software.amazon.awssdk.services.sms.model.GenerateTemplateRequest;
import software.amazon.awssdk.services.sms.model.GenerateTemplateResponse;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.GetAppRequest;
import software.amazon.awssdk.services.sms.model.GetAppResponse;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.GetServersRequest;
import software.amazon.awssdk.services.sms.model.GetServersResponse;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogRequest;
import software.amazon.awssdk.services.sms.model.ImportServerCatalogResponse;
import software.amazon.awssdk.services.sms.model.LaunchAppRequest;
import software.amazon.awssdk.services.sms.model.LaunchAppResponse;
import software.amazon.awssdk.services.sms.model.ListAppsRequest;
import software.amazon.awssdk.services.sms.model.ListAppsResponse;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppLaunchConfigurationResponse;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest;
import software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationResponse;
import software.amazon.awssdk.services.sms.model.StartAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StartAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunRequest;
import software.amazon.awssdk.services.sms.model.StartOnDemandReplicationRunResponse;
import software.amazon.awssdk.services.sms.model.StopAppReplicationRequest;
import software.amazon.awssdk.services.sms.model.StopAppReplicationResponse;
import software.amazon.awssdk.services.sms.model.TerminateAppRequest;
import software.amazon.awssdk.services.sms.model.TerminateAppResponse;
import software.amazon.awssdk.services.sms.model.UpdateAppRequest;
import software.amazon.awssdk.services.sms.model.UpdateAppResponse;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobRequest;
import software.amazon.awssdk.services.sms.model.UpdateReplicationJobResponse;
import software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher;
import software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher;
import software.amazon.awssdk.services.sms.paginators.GetReplicationRunsPublisher;
import software.amazon.awssdk.services.sms.paginators.GetServersPublisher;

/**
 * Service client for accessing SMS asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AAWS Sever Migration Service</fullname>
 * <p>
 * This is the <i>AWS Sever Migration Service API Reference</i>. It provides descriptions, syntax, and usage examples
 * for each of the actions and data types for the AWS Sever Migration Service (AWS SMS). The topic for each action shows
 * the Query API request parameters and the XML response. You can also view the XML request elements in the WSDL.
 * </p>
 * <p>
 * Alternatively, you can use one of the AWS SDKs to access an API that's tailored to the programming language or
 * platform that you're using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.
 * </p>
 * <p>
 * To learn more about the Server Migration Service, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://aws.amazon.com/server-migration-service/">AWS Sever Migration Service product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/server-migration-service/latest/userguide/server-migration.html">AWS Sever
 * Migration Service User Guide</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SmsAsyncClient extends SdkClient {
    String SERVICE_NAME = "sms";

    /**
     * Create a {@link SmsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SmsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SmsAsyncClient}.
     */
    static SmsAsyncClientBuilder builder() {
        return new DefaultSmsAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an application. An application consists of one or more server groups. Each server group contain one or
     * more servers.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application. An application consists of one or more server groups. Each server group contain one or
     * more servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(Consumer<CreateAppRequest.Builder> createAppRequest) {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a replication job. The replication job schedules periodic replication runs to replicate your server to
     * AWS. Each replication run creates an Amazon Machine Image (AMI).
     * </p>
     *
     * @param createReplicationJobRequest
     * @return A Java Future containing the result of the CreateReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ServerCannotBeReplicatedException The specified server cannot be replicated.</li>
     *         <li>ReplicationJobAlreadyExistsException The specified replication job already exists.</li>
     *         <li>NoConnectorsAvailableException There are no connectors available.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>TemporarilyUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.CreateReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicationJobResponse> createReplicationJob(
            CreateReplicationJobRequest createReplicationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication job. The replication job schedules periodic replication runs to replicate your server to
     * AWS. Each replication run creates an Amazon Machine Image (AMI).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationJobRequest#builder()}
     * </p>
     *
     * @param createReplicationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ServerCannotBeReplicatedException The specified server cannot be replicated.</li>
     *         <li>ReplicationJobAlreadyExistsException The specified replication job already exists.</li>
     *         <li>NoConnectorsAvailableException There are no connectors available.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>TemporarilyUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.CreateReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/CreateReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicationJobResponse> createReplicationJob(
            Consumer<CreateReplicationJobRequest.Builder> createReplicationJobRequest) {
        return createReplicationJob(CreateReplicationJobRequest.builder().applyMutation(createReplicationJobRequest).build());
    }

    /**
     * <p>
     * Deletes an existing application. Optionally deletes the launched stack associated with the application and all
     * AWS SMS replication jobs for servers in the application.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing application. Optionally deletes the launched stack associated with the application and all
     * AWS SMS replication jobs for servers in the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes existing launch configuration for an application.
     * </p>
     *
     * @param deleteAppLaunchConfigurationRequest
     * @return A Java Future containing the result of the DeleteAppLaunchConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppLaunchConfigurationResponse> deleteAppLaunchConfiguration(
            DeleteAppLaunchConfigurationRequest deleteAppLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes existing launch configuration for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppLaunchConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAppLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAppLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppLaunchConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAppLaunchConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppLaunchConfigurationResponse> deleteAppLaunchConfiguration(
            Consumer<DeleteAppLaunchConfigurationRequest.Builder> deleteAppLaunchConfigurationRequest) {
        return deleteAppLaunchConfiguration(DeleteAppLaunchConfigurationRequest.builder()
                .applyMutation(deleteAppLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes existing replication configuration for an application.
     * </p>
     *
     * @param deleteAppReplicationConfigurationRequest
     * @return A Java Future containing the result of the DeleteAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppReplicationConfigurationResponse> deleteAppReplicationConfiguration(
            DeleteAppReplicationConfigurationRequest deleteAppReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes existing replication configuration for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAppReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAppReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppReplicationConfigurationResponse> deleteAppReplicationConfiguration(
            Consumer<DeleteAppReplicationConfigurationRequest.Builder> deleteAppReplicationConfigurationRequest) {
        return deleteAppReplicationConfiguration(DeleteAppReplicationConfigurationRequest.builder()
                .applyMutation(deleteAppReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified replication job.
     * </p>
     * <p>
     * After you delete a replication job, there are no further replication runs. AWS deletes the contents of the Amazon
     * S3 bucket used to store AWS SMS artifacts. The AMIs created by the replication runs are not deleted.
     * </p>
     *
     * @param deleteReplicationJobRequest
     * @return A Java Future containing the result of the DeleteReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ReplicationJobNotFoundException The specified replication job does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicationJobResponse> deleteReplicationJob(
            DeleteReplicationJobRequest deleteReplicationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication job.
     * </p>
     * <p>
     * After you delete a replication job, there are no further replication runs. AWS deletes the contents of the Amazon
     * S3 bucket used to store AWS SMS artifacts. The AMIs created by the replication runs are not deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationJobRequest#builder()}
     * </p>
     *
     * @param deleteReplicationJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ReplicationJobNotFoundException The specified replication job does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicationJobResponse> deleteReplicationJob(
            Consumer<DeleteReplicationJobRequest.Builder> deleteReplicationJobRequest) {
        return deleteReplicationJob(DeleteReplicationJobRequest.builder().applyMutation(deleteReplicationJobRequest).build());
    }

    /**
     * <p>
     * Deletes all servers from your server catalog.
     * </p>
     *
     * @param deleteServerCatalogRequest
     * @return A Java Future containing the result of the DeleteServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServerCatalogResponse> deleteServerCatalog(
            DeleteServerCatalogRequest deleteServerCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all servers from your server catalog.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServerCatalogRequest#builder()}
     * </p>
     *
     * @param deleteServerCatalogRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServerCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServerCatalogResponse> deleteServerCatalog(
            Consumer<DeleteServerCatalogRequest.Builder> deleteServerCatalogRequest) {
        return deleteServerCatalog(DeleteServerCatalogRequest.builder().applyMutation(deleteServerCatalogRequest).build());
    }

    /**
     * <p>
     * Deletes all servers from your server catalog.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DeleteServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DeleteServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServerCatalogResponse> deleteServerCatalog() {
        return deleteServerCatalog(DeleteServerCatalogRequest.builder().build());
    }

    /**
     * <p>
     * Disassociates the specified connector from AWS SMS.
     * </p>
     * <p>
     * After you disassociate a connector, it is no longer available to support replication jobs.
     * </p>
     *
     * @param disassociateConnectorRequest
     * @return A Java Future containing the result of the DisassociateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DisassociateConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateConnectorResponse> disassociateConnector(
            DisassociateConnectorRequest disassociateConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified connector from AWS SMS.
     * </p>
     * <p>
     * After you disassociate a connector, it is no longer available to support replication jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateConnectorRequest#builder()}
     * </p>
     *
     * @param disassociateConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.DisassociateConnector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/DisassociateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisassociateConnectorResponse> disassociateConnector(
            Consumer<DisassociateConnectorRequest.Builder> disassociateConnectorRequest) {
        return disassociateConnector(DisassociateConnectorRequest.builder().applyMutation(disassociateConnectorRequest).build());
    }

    /**
     * <p>
     * Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the
     * customer’s Amazon S3 bucket.
     * </p>
     *
     * @param generateChangeSetRequest
     * @return A Java Future containing the result of the GenerateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GenerateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateChangeSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateChangeSetResponse> generateChangeSet(GenerateChangeSetRequest generateChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the
     * customer’s Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link GenerateChangeSetRequest#builder()}
     * </p>
     *
     * @param generateChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link GenerateChangeSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GenerateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GenerateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateChangeSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateChangeSetResponse> generateChangeSet(
            Consumer<GenerateChangeSetRequest.Builder> generateChangeSetRequest) {
        return generateChangeSet(GenerateChangeSetRequest.builder().applyMutation(generateChangeSetRequest).build());
    }

    /**
     * <p>
     * Generates an Amazon CloudFormation template based on the current launch configuration and writes it to an Amazon
     * S3 object in the customer’s Amazon S3 bucket.
     * </p>
     *
     * @param generateTemplateRequest
     * @return A Java Future containing the result of the GenerateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GenerateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateTemplateResponse> generateTemplate(GenerateTemplateRequest generateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an Amazon CloudFormation template based on the current launch configuration and writes it to an Amazon
     * S3 object in the customer’s Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GenerateTemplateRequest#builder()}
     * </p>
     *
     * @param generateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GenerateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GenerateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GenerateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GenerateTemplateResponse> generateTemplate(
            Consumer<GenerateTemplateRequest.Builder> generateTemplateRequest) {
        return generateTemplate(GenerateTemplateRequest.builder().applyMutation(generateTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieve information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppRequest#builder()}
     * </p>
     *
     * @param getAppRequest
     *        A {@link Consumer} that will call methods on {@link GetAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppResponse> getApp(Consumer<GetAppRequest.Builder> getAppRequest) {
        return getApp(GetAppRequest.builder().applyMutation(getAppRequest).build());
    }

    /**
     * <p>
     * Retrieve information about an application.
     * </p>
     *
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppResponse> getApp() {
        return getApp(GetAppRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the application launch configuration associated with an application.
     * </p>
     *
     * @param getAppLaunchConfigurationRequest
     * @return A Java Future containing the result of the GetAppLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAppLaunchConfigurationResponse> getAppLaunchConfiguration(
            GetAppLaunchConfigurationRequest getAppLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the application launch configuration associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetAppLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param getAppLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetAppLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAppLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAppLaunchConfigurationResponse> getAppLaunchConfiguration(
            Consumer<GetAppLaunchConfigurationRequest.Builder> getAppLaunchConfigurationRequest) {
        return getAppLaunchConfiguration(GetAppLaunchConfigurationRequest.builder()
                .applyMutation(getAppLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the application launch configuration associated with an application.
     * </p>
     *
     * @return A Java Future containing the result of the GetAppLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAppLaunchConfigurationResponse> getAppLaunchConfiguration() {
        return getAppLaunchConfiguration(GetAppLaunchConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves an application replication configuration associatd with an application.
     * </p>
     *
     * @param getAppReplicationConfigurationRequest
     * @return A Java Future containing the result of the GetAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAppReplicationConfigurationResponse> getAppReplicationConfiguration(
            GetAppReplicationConfigurationRequest getAppReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an application replication configuration associatd with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetAppReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getAppReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetAppReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAppReplicationConfigurationResponse> getAppReplicationConfiguration(
            Consumer<GetAppReplicationConfigurationRequest.Builder> getAppReplicationConfigurationRequest) {
        return getAppReplicationConfiguration(GetAppReplicationConfigurationRequest.builder()
                .applyMutation(getAppReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves an application replication configuration associatd with an application.
     * </p>
     *
     * @return A Java Future containing the result of the GetAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAppReplicationConfigurationResponse> getAppReplicationConfiguration() {
        return getAppReplicationConfiguration(GetAppReplicationConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     *
     * @param getConnectorsRequest
     * @return A Java Future containing the result of the GetConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectorsResponse> getConnectors(GetConnectorsRequest getConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectorsRequest#builder()}
     * </p>
     *
     * @param getConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectorsResponse> getConnectors(Consumer<GetConnectorsRequest.Builder> getConnectorsRequest) {
        return getConnectors(GetConnectorsRequest.builder().applyMutation(getConnectorsRequest).build());
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     *
     * @return A Java Future containing the result of the GetConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectorsResponse> getConnectors() {
        return getConnectors(GetConnectorsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectorsPublisher getConnectorsPaginator() {
        return getConnectorsPaginator(GetConnectorsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param getConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectorsPublisher getConnectorsPaginator(GetConnectorsRequest getConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connectors registered with the AWS SMS.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetConnectorsPublisher publisher = client.getConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConnectors(software.amazon.awssdk.services.sms.model.GetConnectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectorsRequest#builder()}
     * </p>
     *
     * @param getConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetConnectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectorsPublisher getConnectorsPaginator(Consumer<GetConnectorsRequest.Builder> getConnectorsRequest) {
        return getConnectorsPaginator(GetConnectorsRequest.builder().applyMutation(getConnectorsRequest).build());
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     *
     * @param getReplicationJobsRequest
     * @return A Java Future containing the result of the GetReplicationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReplicationJobsResponse> getReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetReplicationJobsRequest#builder()}
     * </p>
     *
     * @param getReplicationJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReplicationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReplicationJobsResponse> getReplicationJobs(
            Consumer<GetReplicationJobsRequest.Builder> getReplicationJobsRequest) {
        return getReplicationJobs(GetReplicationJobsRequest.builder().applyMutation(getReplicationJobsRequest).build());
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     *
     * @return A Java Future containing the result of the GetReplicationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReplicationJobsResponse> getReplicationJobs() {
        return getReplicationJobs(GetReplicationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReplicationJobsPublisher getReplicationJobsPaginator() {
        return getReplicationJobsPaginator(GetReplicationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation.</b>
     * </p>
     *
     * @param getReplicationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReplicationJobsPublisher getReplicationJobsPaginator(GetReplicationJobsRequest getReplicationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified replication job or all of your replication jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationJobsPublisher publisher = client.getReplicationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetReplicationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReplicationJobs(software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetReplicationJobsRequest#builder()}
     * </p>
     *
     * @param getReplicationJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReplicationJobsPublisher getReplicationJobsPaginator(
            Consumer<GetReplicationJobsRequest.Builder> getReplicationJobsRequest) {
        return getReplicationJobsPaginator(GetReplicationJobsRequest.builder().applyMutation(getReplicationJobsRequest).build());
    }

    /**
     * <p>
     * Describes the replication runs for the specified replication job.
     * </p>
     *
     * @param getReplicationRunsRequest
     * @return A Java Future containing the result of the GetReplicationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReplicationRunsResponse> getReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the replication runs for the specified replication job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationRunsRequest.Builder} avoiding the
     * need to create one manually via {@link GetReplicationRunsRequest#builder()}
     * </p>
     *
     * @param getReplicationRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationRunsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReplicationRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReplicationRunsResponse> getReplicationRuns(
            Consumer<GetReplicationRunsRequest.Builder> getReplicationRunsRequest) {
        return getReplicationRuns(GetReplicationRunsRequest.builder().applyMutation(getReplicationRunsRequest).build());
    }

    /**
     * <p>
     * Describes the replication runs for the specified replication job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReplicationRuns(software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationRunsPublisher publisher = client.getReplicationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationRunsPublisher publisher = client.getReplicationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReplicationRuns(software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest)} operation.</b>
     * </p>
     *
     * @param getReplicationRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReplicationRunsPublisher getReplicationRunsPaginator(GetReplicationRunsRequest getReplicationRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the replication runs for the specified replication job.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReplicationRuns(software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationRunsPublisher publisher = client.getReplicationRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetReplicationRunsPublisher publisher = client.getReplicationRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReplicationRuns(software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationRunsRequest.Builder} avoiding the
     * need to create one manually via {@link GetReplicationRunsRequest#builder()}
     * </p>
     *
     * @param getReplicationRunsRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationRunsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetReplicationRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default GetReplicationRunsPublisher getReplicationRunsPaginator(
            Consumer<GetReplicationRunsRequest.Builder> getReplicationRunsRequest) {
        return getReplicationRunsPaginator(GetReplicationRunsRequest.builder().applyMutation(getReplicationRunsRequest).build());
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     *
     * @param getServersRequest
     * @return A Java Future containing the result of the GetServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServersResponse> getServers(GetServersRequest getServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServersRequest.Builder} avoiding the need to
     * create one manually via {@link GetServersRequest#builder()}
     * </p>
     *
     * @param getServersRequest
     *        A {@link Consumer} that will call methods on {@link GetServersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServersResponse> getServers(Consumer<GetServersRequest.Builder> getServersRequest) {
        return getServers(GetServersRequest.builder().applyMutation(getServersRequest).build());
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     *
     * @return A Java Future containing the result of the GetServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServersResponse> getServers() {
        return getServers(GetServersRequest.builder().build());
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServersPublisher getServersPaginator() {
        return getServersPaginator(GetServersRequest.builder().build());
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.</b>
     * </p>
     *
     * @param getServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServersPublisher getServersPaginator(GetServersRequest getServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the servers in your server catalog.
     * </p>
     * <p>
     * Before you can describe your servers, you must import them using <a>ImportServerCatalog</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sms.paginators.GetServersPublisher publisher = client.getServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sms.model.GetServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sms.model.GetServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServers(software.amazon.awssdk.services.sms.model.GetServersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServersRequest.Builder} avoiding the need to
     * create one manually via {@link GetServersRequest#builder()}
     * </p>
     *
     * @param getServersRequest
     *        A {@link Consumer} that will call methods on {@link GetServersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.GetServers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetServers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServersPublisher getServersPaginator(Consumer<GetServersRequest.Builder> getServersRequest) {
        return getServersPaginator(GetServersRequest.builder().applyMutation(getServersRequest).build());
    }

    /**
     * <p>
     * Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers that you
     * want to import.
     * </p>
     * <p>
     * This call returns immediately, but might take additional time to retrieve all the servers.
     * </p>
     *
     * @param importServerCatalogRequest
     * @return A Java Future containing the result of the ImportServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>NoConnectorsAvailableException There are no connectors available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ImportServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportServerCatalogResponse> importServerCatalog(
            ImportServerCatalogRequest importServerCatalogRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers that you
     * want to import.
     * </p>
     * <p>
     * This call returns immediately, but might take additional time to retrieve all the servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportServerCatalogRequest.Builder} avoiding the
     * need to create one manually via {@link ImportServerCatalogRequest#builder()}
     * </p>
     *
     * @param importServerCatalogRequest
     *        A {@link Consumer} that will call methods on {@link ImportServerCatalogRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>NoConnectorsAvailableException There are no connectors available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ImportServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportServerCatalogResponse> importServerCatalog(
            Consumer<ImportServerCatalogRequest.Builder> importServerCatalogRequest) {
        return importServerCatalog(ImportServerCatalogRequest.builder().applyMutation(importServerCatalogRequest).build());
    }

    /**
     * <p>
     * Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers that you
     * want to import.
     * </p>
     * <p>
     * This call returns immediately, but might take additional time to retrieve all the servers.
     * </p>
     *
     * @return A Java Future containing the result of the ImportServerCatalog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>NoConnectorsAvailableException There are no connectors available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ImportServerCatalog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ImportServerCatalog" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportServerCatalogResponse> importServerCatalog() {
        return importServerCatalog(ImportServerCatalogRequest.builder().build());
    }

    /**
     * <p>
     * Launches an application stack.
     * </p>
     *
     * @param launchAppRequest
     * @return A Java Future containing the result of the LaunchApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.LaunchApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/LaunchApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LaunchAppResponse> launchApp(LaunchAppRequest launchAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches an application stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LaunchAppRequest.Builder} avoiding the need to
     * create one manually via {@link LaunchAppRequest#builder()}
     * </p>
     *
     * @param launchAppRequest
     *        A {@link Consumer} that will call methods on {@link LaunchAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the LaunchApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.LaunchApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/LaunchApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LaunchAppResponse> launchApp(Consumer<LaunchAppRequest.Builder> launchAppRequest) {
        return launchApp(LaunchAppRequest.builder().applyMutation(launchAppRequest).build());
    }

    /**
     * <p>
     * Returns a list of summaries for all applications.
     * </p>
     *
     * @param listAppsRequest
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ListApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsResponse> listApps(ListAppsRequest listAppsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of summaries for all applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppsRequest#builder()}
     * </p>
     *
     * @param listAppsRequest
     *        A {@link Consumer} that will call methods on {@link ListAppsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ListApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsResponse> listApps(Consumer<ListAppsRequest.Builder> listAppsRequest) {
        return listApps(ListAppsRequest.builder().applyMutation(listAppsRequest).build());
    }

    /**
     * <p>
     * Returns a list of summaries for all applications.
     * </p>
     *
     * @return A Java Future containing the result of the ListApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.ListApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/ListApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAppsResponse> listApps() {
        return listApps(ListAppsRequest.builder().build());
    }

    /**
     * <p>
     * Creates a launch configuration for an application.
     * </p>
     *
     * @param putAppLaunchConfigurationRequest
     * @return A Java Future containing the result of the PutAppLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.PutAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAppLaunchConfigurationResponse> putAppLaunchConfiguration(
            PutAppLaunchConfigurationRequest putAppLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch configuration for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAppLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutAppLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param putAppLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutAppLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAppLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.PutAppLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAppLaunchConfigurationResponse> putAppLaunchConfiguration(
            Consumer<PutAppLaunchConfigurationRequest.Builder> putAppLaunchConfigurationRequest) {
        return putAppLaunchConfiguration(PutAppLaunchConfigurationRequest.builder()
                .applyMutation(putAppLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates a replication configuration for an application.
     * </p>
     *
     * @param putAppReplicationConfigurationRequest
     * @return A Java Future containing the result of the PutAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.PutAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAppReplicationConfigurationResponse> putAppReplicationConfiguration(
            PutAppReplicationConfigurationRequest putAppReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a replication configuration for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAppReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutAppReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param putAppReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutAppReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutAppReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.PutAppReplicationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/PutAppReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAppReplicationConfigurationResponse> putAppReplicationConfiguration(
            Consumer<PutAppReplicationConfigurationRequest.Builder> putAppReplicationConfigurationRequest) {
        return putAppReplicationConfiguration(PutAppReplicationConfigurationRequest.builder()
                .applyMutation(putAppReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Starts replicating an application.
     * </p>
     *
     * @param startAppReplicationRequest
     * @return A Java Future containing the result of the StartAppReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StartAppReplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartAppReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartAppReplicationResponse> startAppReplication(
            StartAppReplicationRequest startAppReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replicating an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAppReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link StartAppReplicationRequest#builder()}
     * </p>
     *
     * @param startAppReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartAppReplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartAppReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StartAppReplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartAppReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartAppReplicationResponse> startAppReplication(
            Consumer<StartAppReplicationRequest.Builder> startAppReplicationRequest) {
        return startAppReplication(StartAppReplicationRequest.builder().applyMutation(startAppReplicationRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand replication run for the specified replication job. This replication run starts immediately.
     * This replication run is in addition to the ones already scheduled.
     * </p>
     * <p>
     * There is a limit on the number of on-demand replications runs you can request in a 24-hour period.
     * </p>
     *
     * @param startOnDemandReplicationRunRequest
     * @return A Java Future containing the result of the StartOnDemandReplicationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ReplicationRunLimitExceededException You have exceeded the number of on-demand replication runs you
     *         can request in a 24-hour period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StartOnDemandReplicationRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartOnDemandReplicationRunResponse> startOnDemandReplicationRun(
            StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand replication run for the specified replication job. This replication run starts immediately.
     * This replication run is in addition to the ones already scheduled.
     * </p>
     * <p>
     * There is a limit on the number of on-demand replications runs you can request in a 24-hour period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartOnDemandReplicationRunRequest.Builder}
     * avoiding the need to create one manually via {@link StartOnDemandReplicationRunRequest#builder()}
     * </p>
     *
     * @param startOnDemandReplicationRunRequest
     *        A {@link Consumer} that will call methods on {@link StartOnDemandReplicationRunRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartOnDemandReplicationRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>ReplicationRunLimitExceededException You have exceeded the number of on-demand replication runs you
     *         can request in a 24-hour period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StartOnDemandReplicationRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StartOnDemandReplicationRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartOnDemandReplicationRunResponse> startOnDemandReplicationRun(
            Consumer<StartOnDemandReplicationRunRequest.Builder> startOnDemandReplicationRunRequest) {
        return startOnDemandReplicationRun(StartOnDemandReplicationRunRequest.builder()
                .applyMutation(startOnDemandReplicationRunRequest).build());
    }

    /**
     * <p>
     * Stops replicating an application.
     * </p>
     *
     * @param stopAppReplicationRequest
     * @return A Java Future containing the result of the StopAppReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StopAppReplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StopAppReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopAppReplicationResponse> stopAppReplication(StopAppReplicationRequest stopAppReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops replicating an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAppReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link StopAppReplicationRequest#builder()}
     * </p>
     *
     * @param stopAppReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopAppReplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopAppReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.StopAppReplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StopAppReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopAppReplicationResponse> stopAppReplication(
            Consumer<StopAppReplicationRequest.Builder> stopAppReplicationRequest) {
        return stopAppReplication(StopAppReplicationRequest.builder().applyMutation(stopAppReplicationRequest).build());
    }

    /**
     * <p>
     * Terminates the stack for an application.
     * </p>
     *
     * @param terminateAppRequest
     * @return A Java Future containing the result of the TerminateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.TerminateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/TerminateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateAppResponse> terminateApp(TerminateAppRequest terminateAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the stack for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateAppRequest.Builder} avoiding the need to
     * create one manually via {@link TerminateAppRequest#builder()}
     * </p>
     *
     * @param terminateAppRequest
     *        A {@link Consumer} that will call methods on {@link TerminateAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TerminateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.TerminateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/TerminateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TerminateAppResponse> terminateApp(Consumer<TerminateAppRequest.Builder> terminateAppRequest) {
        return terminateApp(TerminateAppRequest.builder().applyMutation(terminateAppRequest).build());
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     *
     * @param updateAppRequest
     * @return A Java Future containing the result of the UpdateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.UpdateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAppResponse> updateApp(UpdateAppRequest updateAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAppRequest#builder()}
     * </p>
     *
     * @param updateAppRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.UpdateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAppResponse> updateApp(Consumer<UpdateAppRequest.Builder> updateAppRequest) {
        return updateApp(UpdateAppRequest.builder().applyMutation(updateAppRequest).build());
    }

    /**
     * <p>
     * Updates the specified settings for the specified replication job.
     * </p>
     *
     * @param updateReplicationJobRequest
     * @return A Java Future containing the result of the UpdateReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>ServerCannotBeReplicatedException The specified server cannot be replicated.</li>
     *         <li>ReplicationJobNotFoundException The specified replication job does not exist.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>TemporarilyUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.UpdateReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReplicationJobResponse> updateReplicationJob(
            UpdateReplicationJobRequest updateReplicationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified settings for the specified replication job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationJobRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReplicationJobRequest#builder()}
     * </p>
     *
     * @param updateReplicationJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateReplicationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException A specified parameter is not valid.</li>
     *         <li>MissingRequiredParameterException A required parameter is missing.</li>
     *         <li>OperationNotPermittedException This operation is not allowed.</li>
     *         <li>UnauthorizedOperationException You lack permissions needed to perform this operation. Check your IAM
     *         policies, and ensure that you are using the correct access keys.</li>
     *         <li>ServerCannotBeReplicatedException The specified server cannot be replicated.</li>
     *         <li>ReplicationJobNotFoundException The specified replication job does not exist.</li>
     *         <li>InternalErrorException An internal error occurred.</li>
     *         <li>TemporarilyUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SmsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SmsAsyncClient.UpdateReplicationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/UpdateReplicationJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReplicationJobResponse> updateReplicationJob(
            Consumer<UpdateReplicationJobRequest.Builder> updateReplicationJobRequest) {
        return updateReplicationJob(UpdateReplicationJobRequest.builder().applyMutation(updateReplicationJobRequest).build());
    }
}
