/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppResponse extends SmsResponse implements
        ToCopyableBuilder<CreateAppResponse.Builder, CreateAppResponse> {
    private static final SdkField<AppSummary> APP_SUMMARY_FIELD = SdkField.<AppSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateAppResponse::appSummary)).setter(setter(Builder::appSummary)).constructor(AppSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appSummary").build()).build();

    private static final SdkField<List<ServerGroup>> SERVER_GROUPS_FIELD = SdkField
            .<List<ServerGroup>> builder(MarshallingType.LIST)
            .getter(getter(CreateAppResponse::serverGroups))
            .setter(setter(Builder::serverGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateAppResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_SUMMARY_FIELD,
            SERVER_GROUPS_FIELD, TAGS_FIELD));

    private final AppSummary appSummary;

    private final List<ServerGroup> serverGroups;

    private final List<Tag> tags;

    private CreateAppResponse(BuilderImpl builder) {
        super(builder);
        this.appSummary = builder.appSummary;
        this.serverGroups = builder.serverGroups;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Summary description of the application.
     * </p>
     * 
     * @return Summary description of the application.
     */
    public AppSummary appSummary() {
        return appSummary;
    }

    /**
     * Returns true if the ServerGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServerGroups() {
        return serverGroups != null && !(serverGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of server groups included in the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of server groups included in the application.
     */
    public List<ServerGroup> serverGroups() {
        return serverGroups;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of taags associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of taags associated with the application.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appSummary());
        hashCode = 31 * hashCode + Objects.hashCode(serverGroups());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppResponse)) {
            return false;
        }
        CreateAppResponse other = (CreateAppResponse) obj;
        return Objects.equals(appSummary(), other.appSummary()) && Objects.equals(serverGroups(), other.serverGroups())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAppResponse").add("AppSummary", appSummary()).add("ServerGroups", serverGroups())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appSummary":
            return Optional.ofNullable(clazz.cast(appSummary()));
        case "serverGroups":
            return Optional.ofNullable(clazz.cast(serverGroups()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppResponse, T> g) {
        return obj -> g.apply((CreateAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppResponse> {
        /**
         * <p>
         * Summary description of the application.
         * </p>
         * 
         * @param appSummary
         *        Summary description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSummary(AppSummary appSummary);

        /**
         * <p>
         * Summary description of the application.
         * </p>
         * This is a convenience that creates an instance of the {@link AppSummary.Builder} avoiding the need to create
         * one manually via {@link AppSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #appSummary(AppSummary)}.
         * 
         * @param appSummary
         *        a consumer that will call methods on {@link AppSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSummary(AppSummary)
         */
        default Builder appSummary(Consumer<AppSummary.Builder> appSummary) {
            return appSummary(AppSummary.builder().applyMutation(appSummary).build());
        }

        /**
         * <p>
         * List of server groups included in the application.
         * </p>
         * 
         * @param serverGroups
         *        List of server groups included in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(Collection<ServerGroup> serverGroups);

        /**
         * <p>
         * List of server groups included in the application.
         * </p>
         * 
         * @param serverGroups
         *        List of server groups included in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(ServerGroup... serverGroups);

        /**
         * <p>
         * List of server groups included in the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerGroup>.Builder} avoiding the need to
         * create one manually via {@link List<ServerGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #serverGroups(List<ServerGroup>)}.
         * 
         * @param serverGroups
         *        a consumer that will call methods on {@link List<ServerGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroups(List<ServerGroup>)
         */
        Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups);

        /**
         * <p>
         * List of taags associated with the application.
         * </p>
         * 
         * @param tags
         *        List of taags associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * List of taags associated with the application.
         * </p>
         * 
         * @param tags
         *        List of taags associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * List of taags associated with the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private AppSummary appSummary;

        private List<ServerGroup> serverGroups = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppResponse model) {
            super(model);
            appSummary(model.appSummary);
            serverGroups(model.serverGroups);
            tags(model.tags);
        }

        public final AppSummary.Builder getAppSummary() {
            return appSummary != null ? appSummary.toBuilder() : null;
        }

        @Override
        public final Builder appSummary(AppSummary appSummary) {
            this.appSummary = appSummary;
            return this;
        }

        public final void setAppSummary(AppSummary.BuilderImpl appSummary) {
            this.appSummary = appSummary != null ? appSummary.build() : null;
        }

        public final Collection<ServerGroup.Builder> getServerGroups() {
            return serverGroups != null ? serverGroups.stream().map(ServerGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroups(Collection<ServerGroup> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copy(serverGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(ServerGroup... serverGroups) {
            serverGroups(Arrays.asList(serverGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups) {
            serverGroups(Stream.of(serverGroups).map(c -> ServerGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroups(Collection<ServerGroup.BuilderImpl> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copyFromBuilder(serverGroups);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateAppResponse build() {
            return new CreateAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
