/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.batchmanager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class BatchOverrideConfiguration
implements ToCopyableBuilder<Builder, BatchOverrideConfiguration> {
    private final Integer maxBatchSize;
    private final Duration sendRequestFrequency;
    private final Duration receiveMessageVisibilityTimeout;
    private final Duration receiveMessageMinWaitDuration;
    private final List<MessageSystemAttributeName> receiveMessageSystemAttributeNames;
    private final List<String> receiveMessageAttributeNames;

    private BatchOverrideConfiguration(Builder builder) {
        this.maxBatchSize = Validate.isPositiveOrNull((Integer)builder.maxBatchSize, (String)"maxBatchSize");
        Validate.isTrue((this.maxBatchSize == null || this.maxBatchSize <= 10 ? 1 : 0) != 0, (String)"The maxBatchSize must be less than or equal to 10. A batch can contain up to 10 messages.", (Object[])new Object[0]);
        this.sendRequestFrequency = Validate.isPositiveOrNull((Duration)builder.sendRequestFrequency, (String)"sendRequestFrequency");
        this.receiveMessageVisibilityTimeout = Validate.isPositiveOrNull((Duration)builder.receiveMessageVisibilityTimeout, (String)"receiveMessageVisibilityTimeout");
        this.receiveMessageMinWaitDuration = Validate.isPositiveOrNull((Duration)builder.receiveMessageMinWaitDuration, (String)"receiveMessageMinWaitDuration");
        this.receiveMessageSystemAttributeNames = builder.receiveMessageSystemAttributeNames == null ? Collections.emptyList() : Collections.unmodifiableList(builder.receiveMessageSystemAttributeNames);
        this.receiveMessageAttributeNames = builder.receiveMessageAttributeNames == null ? Collections.emptyList() : Collections.unmodifiableList(builder.receiveMessageAttributeNames);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration sendRequestFrequency() {
        return this.sendRequestFrequency;
    }

    public Duration receiveMessageVisibilityTimeout() {
        return this.receiveMessageVisibilityTimeout;
    }

    public Duration receiveMessageMinWaitDuration() {
        return this.receiveMessageMinWaitDuration;
    }

    public List<MessageSystemAttributeName> receiveMessageSystemAttributeNames() {
        return this.receiveMessageSystemAttributeNames;
    }

    public List<String> receiveMessageAttributeNames() {
        return this.receiveMessageAttributeNames;
    }

    public Builder toBuilder() {
        return new Builder().maxBatchSize(this.maxBatchSize).sendRequestFrequency(this.sendRequestFrequency).receiveMessageVisibilityTimeout(this.receiveMessageVisibilityTimeout).receiveMessageMinWaitDuration(this.receiveMessageMinWaitDuration).receiveMessageSystemAttributeNames(this.receiveMessageSystemAttributeNames).receiveMessageAttributeNames(this.receiveMessageAttributeNames);
    }

    public String toString() {
        return ToString.builder((String)"BatchOverrideConfiguration").add("maxBatchSize", (Object)this.maxBatchSize).add("sendRequestFrequency", (Object)this.sendRequestFrequency).add("receiveMessageVisibilityTimeout", (Object)this.receiveMessageVisibilityTimeout).add("receiveMessageMinWaitDuration", (Object)this.receiveMessageMinWaitDuration).add("receiveMessageSystemAttributeNames", this.receiveMessageSystemAttributeNames).add("receiveMessageAttributeNames", this.receiveMessageAttributeNames).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchOverrideConfiguration that = (BatchOverrideConfiguration)o;
        if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) {
            return false;
        }
        if (this.sendRequestFrequency != null ? !this.sendRequestFrequency.equals(that.sendRequestFrequency) : that.sendRequestFrequency != null) {
            return false;
        }
        if (this.receiveMessageVisibilityTimeout != null ? !this.receiveMessageVisibilityTimeout.equals(that.receiveMessageVisibilityTimeout) : that.receiveMessageVisibilityTimeout != null) {
            return false;
        }
        if (this.receiveMessageMinWaitDuration != null ? !this.receiveMessageMinWaitDuration.equals(that.receiveMessageMinWaitDuration) : that.receiveMessageMinWaitDuration != null) {
            return false;
        }
        if (this.receiveMessageSystemAttributeNames != null ? !this.receiveMessageSystemAttributeNames.equals(that.receiveMessageSystemAttributeNames) : that.receiveMessageSystemAttributeNames != null) {
            return false;
        }
        return this.receiveMessageAttributeNames != null ? this.receiveMessageAttributeNames.equals(that.receiveMessageAttributeNames) : that.receiveMessageAttributeNames == null;
    }

    public int hashCode() {
        int result = this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0;
        result = 31 * result + (this.sendRequestFrequency != null ? this.sendRequestFrequency.hashCode() : 0);
        result = 31 * result + (this.receiveMessageVisibilityTimeout != null ? this.receiveMessageVisibilityTimeout.hashCode() : 0);
        result = 31 * result + (this.receiveMessageMinWaitDuration != null ? this.receiveMessageMinWaitDuration.hashCode() : 0);
        result = 31 * result + (this.receiveMessageSystemAttributeNames != null ? this.receiveMessageSystemAttributeNames.hashCode() : 0);
        result = 31 * result + (this.receiveMessageAttributeNames != null ? this.receiveMessageAttributeNames.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements CopyableBuilder<Builder, BatchOverrideConfiguration> {
        private Integer maxBatchSize = 10;
        private Duration sendRequestFrequency;
        private Duration receiveMessageVisibilityTimeout;
        private Duration receiveMessageMinWaitDuration;
        private List<MessageSystemAttributeName> receiveMessageSystemAttributeNames = Collections.emptyList();
        private List<String> receiveMessageAttributeNames = Collections.emptyList();

        private Builder() {
        }

        public Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder sendRequestFrequency(Duration sendRequestFrequency) {
            this.sendRequestFrequency = sendRequestFrequency;
            return this;
        }

        public Builder receiveMessageVisibilityTimeout(Duration receiveMessageVisibilityTimeout) {
            this.receiveMessageVisibilityTimeout = receiveMessageVisibilityTimeout;
            return this;
        }

        public Builder receiveMessageMinWaitDuration(Duration receiveMessageMinWaitDuration) {
            this.receiveMessageMinWaitDuration = receiveMessageMinWaitDuration;
            return this;
        }

        public Builder receiveMessageSystemAttributeNames(List<MessageSystemAttributeName> receiveMessageSystemAttributeNames) {
            this.receiveMessageSystemAttributeNames = receiveMessageSystemAttributeNames != null ? new ArrayList<MessageSystemAttributeName>(receiveMessageSystemAttributeNames) : Collections.emptyList();
            return this;
        }

        public Builder receiveMessageAttributeNames(List<String> receiveMessageAttributeNames) {
            this.receiveMessageAttributeNames = receiveMessageAttributeNames != null ? new ArrayList<String>(receiveMessageAttributeNames) : Collections.emptyList();
            return this;
        }

        public BatchOverrideConfiguration build() {
            return new BatchOverrideConfiguration(this);
        }
    }
}

