/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.AttributeMap;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class SqsClientContextParams<T> extends AttributeMap.Key<T> {
    /**
     * Enable message MD5 checksum validation.
     * <p>
     * Checksum validation for messages defaults to true. Only set to false if required, for instance if your
     * cryptographic library does not support MD5.
     * <p>
     * Supported operations are SendMessage, ReceiveMessage and SendMessageBatch.
     */
    public static final SqsClientContextParams<Boolean> CHECKSUM_VALIDATION_ENABLED = new SqsClientContextParams<>(Boolean.class);

    private SqsClientContextParams(Class<T> valueClass) {
        super(valueClass);
    }
}
